#!/usr/bin/env python3
# -*- coding: utf8 -*-
#######################################
from tkinter import *  # unter linux wahrscheinlich nachzuinstallieren via: sudo apt-get install python3-tk
from tkinter import font
from tkinter import ttk
from tkinter import messagebox
import math
from re import match  # für unkennify
from urllib.parse import unquote as urllib_parse_unquote  # für nak-nak
from urllib import request
from itertools import chain  # für primfaktoren zerlegung
import webbrowser  # für website in Infofenster
import binascii  # für base64_ascii

#######################################
versionsnummer = "Version: 1.10 (17. März 2024)"
website = "http://mysteryhelfer.tba-tm.bplaced.net"
#######################################

# Standard falls laden der data/config.txt schief geht
schriftart, schriftgroesse, schriftstyle = "Times New Roman", 10, "normal"

# Schrift-entsprechend data/config.txt anpassen
try:
    configfile = open("./data/config.txt", "r", encoding="UTF-8")
    for line in configfile:
        line = line.strip(" \t\n\r")
        if line[:1] == "#":
            continue
        elif line[:4] == "size":
            line = line.split("=")
            schriftgroesse = int(line[1].strip(" \t\n\r"))
        elif line[:4] == "font":
            line = line.split("=")
            schriftart = line[1].strip(" \t\n\r")
        elif line[:5] == "style":
            line = line.split("=")
            schriftstyle = line[1].strip(" \t\n\r")
    configfile.close()
except FileNotFoundError:
    pass

schrift = (schriftart, schriftgroesse, schriftstyle)


# allgemeine Funktionen
def trennlinie():
    Ausgabe.insert(1.0, "-------------------------------------------------\n")


def check_update():
    url = website + "/version.txt"
    try:
        response = request.urlopen(url)
        latest_version = response.read().decode().strip()
        if latest_version == versionsnummer:  # Vergleiche die abgerufene Version mit der aktuellen Version
            message = "Du verwendest die aktuellste Version."
        else:
            message = f"Ein Update ist verfügbar!\n\nDu verwendest {versionsnummer}\n{latest_version} ist " \
                      f"auf {website} verfügbar.\n\n (Einen anklickbaren Link zur Webseite findest du,\n wenn" \
                      f" du auf das Logo klickst.)"
    except request.HTTPError:
        message = "Es konnte leider keine Verbindung zum Update-Server hergestellt werden."

    # Zeige das Ergebnis in einem Dialogfenster an
    messagebox.showinfo("Update-Check", message)


# ***recursive quersummenfunktion***
def q_sum(n):
    if n < 10:
        return n
    else:
        n = q_sum(n // 10) + n % 10
        return n


# ***recursive iterierte quersummenfunktion***
def iq_sum(n):
    if n < 10:
        return n
    else:
        n = iq_sum(q_sum(n))
        return n


# ***produziert eine Liste mit Primzahlen kleiner als grenze***
# ***nach dem Prinzip des "Sieb des Eratosthenes"***
def primzahlliste(grenze):
    primes = []
    is_prime = [True] * grenze
    is_prime[0] = False
    is_prime[1] = False
    for i in range(2, int(math.sqrt(grenze))):
        if is_prime[i]:
            for j in range((i * i), grenze, i):
                is_prime[j] = False
    for i in range(len(is_prime)):
        if is_prime[i]:
            primes.append(i)
    return primes


# ***alle permutationen generieren***
def all_perms(liste):
    if len(liste) <= 1:
        yield liste
    else:
        for perm in all_perms(liste[1:]):
            for i in range(len(perm) + 1):
                yield perm[:i] + liste[0:1] + perm[i:]


# ***zählfunktionen für anagramm suche
def buchstabenzaehl(buchstabe, anzahl):
    if buchstabe in anzahl:
        anzahl[buchstabe] = anzahl[buchstabe] + 1
    else:
        anzahl[buchstabe] = 1


def wortzaehl(wort):
    anzahl = {}
    for buchstabe in wort:
        buchstabenzaehl(buchstabe.upper(), anzahl)
    return anzahl


# ***Funktionen für Kachelkoordinaten/Maptiles-Funktion
def dec_to_maptiles(lat_deg, lon_deg, zoom):
    lat_rad = math.radians(lat_deg)
    n = 2.0 ** zoom
    xtile = int((lon_deg + 180.0) / 360.0 * n)
    ytile = int((1.0 - math.log(math.tan(lat_rad) + (1 / math.cos(lat_rad))) / math.pi) / 2.0 * n)
    return xtile, ytile


def maptiles_to_dec(xtile, ytile, zoom):
    n = 2.0 ** zoom
    lon_dec = xtile / n * 360.0 - 180.0
    lat_rad = math.atan(math.sinh(math.pi * (1 - 2 * ytile / n)))
    lat_dec = math.degrees(lat_rad)
    return lat_dec, lon_dec


# ***Dezimalgrad in Dezimalminuten (Ausgabe als String)
def dec_to_deg(lat_dec, lon_dec):
    if lat_dec < 0:
        lat_pre = "S"
    else:
        lat_pre = "N"
    if lon_dec < 0:
        lon_pre = "W"
    else:
        lon_pre = "E"
    lat = abs(lat_dec)
    lon = abs(lon_dec)
    lat_degree = int(lat)
    lon_degree = int(lon)
    lat_minutes = (lat - lat_degree) * 60
    lon_minutes = (lon - lon_degree) * 60
    return ("{}{} {:.3f} {}{} {:.3f}".format(lat_pre, lat_degree, round(lat_minutes, 3), lon_pre, lon_degree,
                                             round(lon_minutes, 3)))


# ***ReverseWherIGo zu Dezimalgrad
def rwig_to_coords(a, b, c):
    lat, lon = 0, 0
    a = int(a)
    b = int(b)
    c = int(c)
    if (a % 1000 - a % 100) / 100 == 1:
        lat_sign = 1
        lon_sign = 1
    elif (a % 1000 - a % 100) / 100 == 2:
        lat_sign = -1
        lon_sign = 1
    elif (a % 1000 - a % 100) / 100 == 3:
        lat_sign = 1
        lon_sign = -1
    elif (a % 1000 - a % 100) / 100 == 4:
        lat_sign = -1
        lon_sign = -1
    else:
        return 0, 0
    if ((c % 100000 - c % 10000) / 10000 + (c % 100 - c % 10) / 10) % 2 == 0:
        lat = lat_sign * (
                (a % 10000 - a % 1000) / 100
                + (b % 100 - b % 10) / 10
                + (b % 100000 - b % 10000) / 100000
                + (c % 1000 - c % 100) / 10000
                + (a % 1000000 - a % 100000) / 100000000
                + (c % 100 - c % 10) / 100000
                + a % 10 * 1.0E-5)
    elif ((c % 100000 - c % 10000) / 10000 + (c % 100 - c % 10) / 10) % 2 != 0:
        lat = lat_sign * (
                (b % 1000000 - b % 100000) / 10000
                + a % 10 + (a % 10000 - a % 1000) / 10000
                + (c % 1000000 - c % 100000) / 10000000
                + (c % 1000 - c % 100) / 100000
                + (c % 100 - c % 10) / 100000
                + (a % 1000000 - a % 100000) / 10000000000)
    if ((c % 100000 - c % 10000) / 10000 + (c % 100 - c % 10) / 10) % 2 == 0:
        lon = lon_sign * (
                (a % 100000 - a % 10000) / 100
                + (c % 1000000 - c % 100000) / 10000
                + c % 10 + (b % 1000 - b % 100) / 1000
                + (b % 1000000 - b % 100000) / 10000000
                + (a % 100 - a % 10) / 10000
                + (c % 100000 - c % 10000) / 100000000
                + b % 10 * 1.0E-5)
    elif ((c % 100000 - c % 10000) / 10000 + (c % 100 - c % 10) / 10) % 2 != 0:
        lon = lon_sign * (
                (b % 100 - b % 10) * 10
                + c % 10 * 10
                + (a % 100 - a % 10) / 10
                + (a % 100000 - a % 10000) / 100000
                + (b % 1000 - b % 100) / 10000
                + b % 10 * 0.001
                + (c % 100000 - c % 10000) / 100000000
                + (b % 100000 - b % 10000) / 1000000000)
    return round(lat, 5), round(lon, 5)


LOGOIMG = """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"""


# ***************************Buttonactions***************************
def ausgabe_leeren():
    Ausgabe.delete(1.0, END)


def eingabe_leeren():
    Eingabe.delete(1.0, END)


def eingabe_einfuegen():
    Eingabe.delete(1.0, END)
    Eingabe.event_generate("<<Paste>>")


def auswahl_kopieren():
    Ausgabe.event_generate("<<Copy>>")


def cesar_all():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":

        Ausgabe.insert(1.0, """HILFE: [Cesar-Verschiebe-Chiffre]
Von der eingegebenen Zeichenkette werden,
alle möglichen Verschiebungen gemäß der
Cesarchiffre generiert und ausgegeben.
Sonderzeichen und Zahlen werden unverändert
wiedergegeben.""" + "\n\n")
    else:
        abcgross = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        abcklein = "abcdefghijklmnopqrstuvwxyz"
        txt = eingabetext
        for r in range(25, 0, -1):
            atxt = ""
            for i in txt:
                if i.upper() not in abcgross:
                    atxt = atxt + i  # nicht codierbare Zeichen direkt zur Ausgabe bitte!
                    continue
                abc = abcgross
                if i == i.lower():
                    abc = abcklein
                for j in range(26):
                    if i == abc[j]:
                        if j + r >= 26:
                            atxt = atxt + abc[j + r - 26]
                        else:
                            atxt = atxt + abc[j + r]
            Ausgabe.insert(1.0, " " + atxt + "\n")
            Ausgabe.insert(1.0, "{:0>2}({:0>2}):".format(r, 26 - r), "bu")
            # {:0>2} bedeutet: 0 = Füllzeichen, > = rechtsbündig, 2 = Ausgabebreite


def buchstabenwortwert():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Buchstabenwortwerte ermitteln]
Diese Funktion berechnet den Buchstabenwert
der eingegeben Zeichenkette. (A=1 B=2 .... 
Ä=27 Ö=28 Ü=29 ß=30) Bei mehreren durch
Leerzeichen getrennten Wörtern wird auch
für jedes einzelne Wort der Wortwert errechnet.
Desweiteren wird die Quersumme und die iterierte
Quersumme des Gesamtbuchstabenwertes als auch für
jedes Wort das Buchstabenwertprodukt und das 
Gesamtbuchstabenwertprodukt ermittelt.""" + "\n\n")
    else:
        bw = {'A': 1, 'B': 2, 'C': 3, 'D': 4, 'E': 5, 'F': 6, 'G': 7, 'H': 8, 'I': 9, 'J': 10, 'K': 11, 'L': 12,
              'M': 13, 'N': 14,
              'O': 15, 'P': 16, 'Q': 17, 'R': 18, 'S': 19, 'T': 20, 'U': 21, 'V': 22, 'W': 23, 'X': 24, 'Y': 25,
              'Z': 26,
              'Ä': 27, 'Ö': 28, 'Ü': 29, 'SS': 30}
        wortsumme = 0
        wortprodukt = 1
        atxt = ""
        az = ""
        eworttxt = ""
        ewortptxt = ""
        banzahla = 0
        banzwtxt = ""
        einzelworte = eingabetext.split()
        for wort in einzelworte:
            ewortsumme = 0
            ewortprod = 1
            banzahlw = 0
            ewtr = False
            for b in wort:
                if b.upper() not in bw:
                    atxt = atxt + b + "=0 "
                    az = az + "0,"
                    continue
                else:
                    ewtr = True
                    ewortprod *= bw[b.upper()]
                    ewortsumme += bw[b.upper()]
                    wortsumme += bw[b.upper()]
                    wortprodukt *= bw[b.upper()]
                    atxt = atxt + b + "=" + str(bw[b.upper()]) + " "
                    az = az + str(bw[b.upper()]) + ","
                    banzahla += 1
                    banzahlw += 1
            banzwtxt = banzwtxt + str(banzahlw) + "/"
            eworttxt = eworttxt + str(ewortsumme) + "/"
            if not ewtr:
                ewortptxt = ewortptxt + "0/"
            else:
                ewortptxt = ewortptxt + str(ewortprod) + "/"
        Ausgabe.insert(1.0, str(wortprodukt) + "\n")
        Ausgabe.insert(1.0, "Buchstabenwert-Produkt:(Nullen werden ignoriert):\n", "bu")
        Ausgabe.insert(1.0, ewortptxt[0:-1] + "\n")
        Ausgabe.insert(1.0, "Wortprodukte(0 wenn kein Buchstabe gefunden):\n", "bu")
        Ausgabe.insert(1.0, str(banzahla) + "\n")
        Ausgabe.insert(1.0, "Gesamtanzahl aller Buchstaben:", "bu")
        Ausgabe.insert(1.0, banzwtxt[0:-1] + "\n")
        Ausgabe.insert(1.0, "Buchstabenanzahl pro Wort:", "bu")
        Ausgabe.insert(1.0, str(q_sum(wortsumme)) + " / " + str(iq_sum(wortsumme)) + "\n")
        Ausgabe.insert(1.0, "Quersumme der Summe aller Buchstabenwerte / iterierte Quersumme:", "bu")
        Ausgabe.insert(1.0, str(wortsumme) + "\n")
        Ausgabe.insert(1.0, "Summe aller Buchstabenwerte:", "bu")
        Ausgabe.insert(1.0, eworttxt[0:-1] + "\n")
        Ausgabe.insert(1.0, "Buchstabenwortwerte:", "bu")
        Ausgabe.insert(1.0, az[0:-1] + "\n")
        Ausgabe.insert(1.0, "Buchstabenwerte:", "bu")
        Ausgabe.insert(1.0, atxt + "\n")


def buchstabenwertzutext():
    seperator = ("|,", "_", ".", "-", "/", ";", ",")
    bw = {1: 'a', 2: 'b', 3: 'c', 4: 'd', 5: 'e', 6: 'f', 7: 'g', 8: 'h', 9: 'i', 10: 'j', 11: 'k',
          12: 'l', 13: 'm', 14: 'n', 15: 'o', 16: 'p', 17: 'q', 18: 'r', 19: 's', 20: 't', 21: 'u',
          22: 'v', 23: 'w', 24: 'x', 25: 'y', 26: 'z', 27: 'ä', 28: 'ö', 29: 'ü', 30: 'ß'}
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Buchstabenwerte zu Text]
Die eingegebenen Buchstabenwert werden in die
entsprechenden Buchstaben umgewandelt.
(A=1 B=2 .... Ä=27 Ö=28 Ü=29 ß=30)
Als Trennungszeichen zwischen den Zahlen sind
folgende Zeichen erlaubt: | , _ . - / ; , und 
Leerzeichen. Bei Verwendung von Leerzeichen
sollten möglichst nur 1 Leerzeichen zwischen
den Zahlen verwendet werden (überzählige
Leerzeichen werden sonst als nicht erkannte
Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; . / - _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                if ausz not in bw:
                    Ausgabe.insert(1.0, "Die eingegebene Zahl ist kein gültiger Buchstabenwert!\n", "re")
                else:
                    Ausgabe.insert(1.0, bw[ausz] + "\n")
        else:
            txt = eingabetext.split(se)
            atxt = ""
            ignor = ""
            for z in txt:
                try:
                    az = int(z)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    if az in bw:
                        atxt = atxt + bw[az]
                    else:
                        ignor = ignor + str(z) + " "
            Ausgabe.insert(1.0, atxt + "\n")
            Ausgabe.insert(1.0, "umgewandelte Zeichen:\n", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung folgendes wurde ignoriert:\n", "re")


def zeichenkette_rueckwaerts():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Zeichenkette rückwärts]
Diese Funktion gibt die eingegebene Zeichenkette
von hinten nach vorn gelesen aus.\n""")
    else:
        Ausgabe.insert(1.0, eingabetext[::-1] + "\n")


def zeichenzaehlen():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Zeichenzählen]
Es wird das Vorkommen jedes einzelnen Zeichens gezählt
und ausgegeben. 
Achtung! Leerzeichen, Tabulatorzeichen und Zeilenumbrüche
werden nur vor dem letzten sichtbaren Zeichen gezählt!!!""" + "\n\n")
    else:
        anzahl = {}
        for b in eingabetext:
            if b in anzahl:
                anzahl[b] = anzahl[b] + 1
            else:
                anzahl[b] = 1
        s = []
        for key in anzahl:
            s.append(key)
        s.sort(reverse=True)
        for i in s:
            if ord(i) == 9:
                Ausgabe.insert(1.0, "[TAB] = {} mal\n".format(anzahl[i]))
            elif ord(i) == 32:
                Ausgabe.insert(1.0, "[SPACE] = {} mal\n".format(anzahl[i]))
            elif ord(i) == 10:
                Ausgabe.insert(1.0, "[LINEFEED] = {} mal\n".format(anzahl[i]))
            else:
                Ausgabe.insert(1.0, "{} = {} mal\n".format(i, anzahl[i]))
        Ausgabe.insert(1.0, "Es wurden {} unterschiedliche Zeichen gefunden.\n".format(len(anzahl)))


def quersummen():
    seperator = ("|,", "_", ".", "-", "/", ";", ",")
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Quersumme(n)]
Von den eingegebenen Zahlen werden die
Quersummen und iterierten Quersummen errechnet
und ausgegeben.
Als Trennungszeichen zwischen den Zahlen sind
folgende Zeichen erlaubt: | , _ . - / ; , und 
Leerzeichen. Bei Verwendung von Leerzeichen
sollten möglichst nur 1 Leerzeichen zwischen
den Zahlen verwendet werden (überzählige
Leerzeichen werden sonst als nicht erkannte
Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; . / - _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                Ausgabe.insert(1.0, "Quersumme: {}  iterierte Quersumme: {}\n".format(q_sum(ausz), iq_sum(ausz)))
        else:
            txt = eingabetext.split(se)
            qtxt = ""
            iqtxt = ""
            ignor = ""
            for z in txt:
                try:
                    az = int(z)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    qtxt = qtxt + str(q_sum(az)) + "/"
                    iqtxt = iqtxt + str(iq_sum(az)) + "/"
            Ausgabe.insert(1.0, iqtxt[:-1] + "\n")
            Ausgabe.insert(1.0, "iterierte Quersummen\n", "bu")
            Ausgabe.insert(1.0, qtxt[:-1] + "\n")
            Ausgabe.insert(1.0, "Quersummen:\n", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung nicht erkannte Zeichen:\n", "re")


def einschluessemit4():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Einschlüsse zählen]
Es werden die Einschlüsse in Buchstaben und
Ziffern gezählt. Neben der Anzahl der Einschlüss
für jeden einzelnen Buchstaben, für jedes Wort und
die gesammte Eingabe ermittelt.
Da es sich bei der Zahl 4 je nach Schreibweise um
eine Zahl mit oder ohne Einschluß handeln kann gibt
es zwei Versionen.
!!! Hier ist Klein- und Großschreibung wichtig, denn
z.B. b=1 aber B=2 !!!""" + "\n\n")
    else:
        bw1 = "ADOPQRabdegopq4690"
        wortsummenliste = []
        wortliste = eingabetext.split()
        az = ""
        for wort in wortliste:
            wz = 0
            for b in wort:
                if b == "B" or b == "8":
                    az = az + "2"
                    wz = wz + 2
                elif b in bw1:
                    az = az + "1"
                    wz = wz + 1
                else:
                    az = az + "0"
            az = az + " "
            wortsummenliste.append(wz)
        Ausgabe.insert(1.0, str(sum(wortsummenliste)) + "\n")
        Ausgabe.insert(1.0, "insgesamt gefundene Einschlüsse:", "bu")
        wtxt = ""
        for z in wortsummenliste:
            wtxt = wtxt + str(z) + " "
        Ausgabe.insert(1.0, wtxt + "\n")
        Ausgabe.insert(1.0, "Einschlüsse pro Wort:", "bu")
        Ausgabe.insert(1.0, az + "\n")
        Ausgabe.insert(1.0, "Einschlüsse je Zeichen:\n", "bu")


def einschluesseohne4():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Einschlüsse zählen]
Es werden die Einschlüsse in Buchstaben und
Ziffern gezählt. Neben der Anzahl der Einschlüss
für jeden einzelnen Buchstaben, für jedes Wort und
die gesammte Eingabe ermittelt.
Da es sich bei der Zahl 4 je nach Schreibweise um
eine Zahl mit oder ohne Einschluß handeln kann gibt
es zwei Versionen.
!!! Hier ist Klein- und Großschreibung wichtig, denn
z.B. b=1 aber B=2 !!!""" + "\n\n")
    else:
        bw1 = "ADOPQRabdegopq690"
        wortsummenliste = []
        wortliste = eingabetext.split()
        az = ""
        for wort in wortliste:
            wz = 0
            for b in wort:
                if b == "B" or b == "8":
                    az = az + "2"
                    wz = wz + 2
                elif b in bw1:
                    az = az + "1"
                    wz = wz + 1
                else:
                    az = az + "0"
            az = az + " "
            wortsummenliste.append(wz)
        Ausgabe.insert(1.0, str(sum(wortsummenliste)) + "\n")
        Ausgabe.insert(1.0, "insgesamt gefundene Einschlüsse:", "bu")
        wtxt = ""
        for z in wortsummenliste:
            wtxt = wtxt + str(z) + " "
        Ausgabe.insert(1.0, wtxt + "\n")
        Ausgabe.insert(1.0, "Einschlüsse pro Wort:", "bu")
        Ausgabe.insert(1.0, az + "\n")
        Ausgabe.insert(1.0, "Einschlüsse je Zeichen:\n", "bu")


def morsetoabc():
    alphabet = {".-": "A", "-...": "B", "-.-.": "C", "-..": "D", ".": "E", "..-.": "F", "--.": "G", "....": "H",
                "..": "I", ".---": "J", "-.-": "K", ".-..": "L",
                "--": "M", "-.": "N", "---": "O", ".--.": "P", "--.-": "Q", ".-.": "R", "...": "S", "-": "T",
                "..-": "U", "...-": "V", ".--": "W", "-..-": "X", "-.--": "Y",
                "--..": "Z", ".----": "1", "..---": "2", "...--": "3", "....-": "4", ".....": "5", "-....": "6",
                "--...": "7", "---..": "8", "----.": "9", "-----": "0", "--.--": "Ñ",
                "..-..": "É", ".-..-": "È", ".--.-": "À", "..--": "Ü", "---.": "Ö", ".-.-": "Ä", "..--.-": "_",
                ".--.-.": "@", "..--..": "?", "-...-": "=", "-.-.-.": ";", "---...": ":",
                "-..-.": "/", ".-.-.-": ".", "-....-": "-", "--..--": ",", ".-.-.": "+", "-.--.-": ")", "-.--.": "(",
                ".----.": "'", "...--..": "ß"
                }
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Morsecode zu Text]
Die Eingabe des Morsecodes hat wie folgt zu erfolgen:
- für lang und . für kurz, zwischen den Buchstaben ein
Leerzeichen und als Worttrennung ein / wobei davor und
danach ein Leerzeichen steht.
Für unbekannte Morsecodes erscheint in der Ausgabe ein #.""" + "\n\n")
    else:
        morse = eingabetext.split()
        atxt = ""
        for sign in morse:
            if sign == "/":
                atxt = atxt + " "
            elif sign not in alphabet:
                atxt = atxt + "#"
            else:
                atxt = atxt + alphabet[sign]
        Ausgabe.insert(1.0, atxt + "\n")


def abctomorse():
    alphabet = {".-": "A", "-...": "B", "-.-.": "C", "-..": "D", ".": "E", "..-.": "F", "--.": "G", "....": "H",
                "..": "I", ".---": "J", "-.-": "K", ".-..": "L",
                "--": "M", "-.": "N", "---": "O", ".--.": "P", "--.-": "Q", ".-.": "R", "...": "S", "-": "T",
                "..-": "U", "...-": "V", ".--": "W", "-..-": "X", "-.--": "Y",
                "--..": "Z", ".----": "1", "..---": "2", "...--": "3", "....-": "4", ".....": "5", "-....": "6",
                "--...": "7", "---..": "8", "----.": "9", "-----": "0", "--.--": "Ñ",
                "..-..": "É", ".-..-": "È", ".--.-": "À", "..--": "Ü", "---.": "Ö", ".-.-": "Ä", "..--.-": "_",
                ".--.-.": "@", "..--..": "?", "-...-": "=", "-.-.-.": ";", "---...": ":",
                "-..-.": "/", ".-.-.-": ".", "-....-": "-", "--..--": ",", ".-.-.": "+", "-.--.-": ")", "-.--.": "(",
                ".----.": "'", "...--..": "SS"
                }
    umkehr_alpha = {v: k for k, v in alphabet.items()}  # Alphabet mit getauschten key und values generieren
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Text zu Morsecode]
Eingabetext wird als Morsecode ausgegeben.
Nicht kodierbare Zeichen erscheinen unverändert
in der Ausgabe.""" + "\n\n")
    else:
        atxt = ""
        for b in eingabetext:
            if b == " ":
                atxt = atxt + "/ "
            elif b.upper() not in umkehr_alpha:
                atxt = atxt + b + " "
            else:
                atxt = atxt + umkehr_alpha[b.upper()] + " "
        Ausgabe.insert(1.0, atxt + "\n")


def rot5():
    ro5 = {"0": "5", "1": "6", "2": "7", "3": "8", "4": "9", "5": "0", "6": "1", "7": "2", "8": "3", "9": "4"}
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [ROT 5]
ROT 5 bezeichnet eine Verschiebechiffrierung, bei
welcher die Ziffern 0-9 um je 5 Stellen verschoben
werden. Aus 0 wird 5, aus 1 wird 6, aus 7 wird 2,usw.
Kodieren und Dekodieren geschieht hier mit ein und
derselben Funktion, alle Zeichen die keine Ziffern
sind werden unverändert wiedergegeben.""" + "\n\n")
    else:
        atxt = ""
        for z in eingabetext:
            if z not in ro5:
                atxt = atxt + z
            else:
                atxt = atxt + ro5[z]
        Ausgabe.insert(1.0, atxt + "\n")


def rot13():
    ro13 = {'A': 'N', 'B': 'O', 'C': 'P', 'D': 'Q', 'E': 'R', 'F': 'S', 'G': 'T', 'H': 'U', 'I': 'V', 'J': 'W',
            'K': 'X', 'L': 'Y', 'M': 'Z',
            'N': 'A', 'O': 'B', 'P': 'C', 'Q': 'D', 'R': 'E', 'S': 'F', 'T': 'G', 'U': 'H', 'V': 'I', 'W': 'J',
            'X': 'K', 'Y': 'L', 'Z': 'M'}
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [ROT 13]
ROT 13 bezeichnet eine Verschiebechiffrierung, bei
welcher die 26 Buchstaben (A-Z) um genau 13 Stellen
verschoben werden. Da dies genau die Hälfte des Alphabets
ist, wird z.B. aus einem A ein N und aus einem N ein A
und somit wird über die selbe Funktion sowohl kodiert als
auch dekodiert. Die Klein- und Großschreibung bleibt
erhalten und alle Zeichen die keine Buchstaben sind 
werden unverändert wiedergegeben.""" + "\n\n")
    else:
        atxt = ""
        for z in eingabetext:
            if z.upper() not in ro13:
                atxt = atxt + z
            elif z.lower() == z:
                a = ro13[z.upper()]
                atxt = atxt + a.lower()
            else:
                atxt = atxt + ro13[z.upper()]
        Ausgabe.insert(1.0, atxt + "\n")


def rot18():
    ro18 = {'A': 'N', 'B': 'O', 'C': 'P', 'D': 'Q', 'E': 'R', 'F': 'S', 'G': 'T', 'H': 'U', 'I': 'V', 'J': 'W',
            'K': 'X', 'L': 'Y', 'M': 'Z',
            'N': 'A', 'O': 'B', 'P': 'C', 'Q': 'D', 'R': 'E', 'S': 'F', 'T': 'G', 'U': 'H', 'V': 'I', 'W': 'J',
            'X': 'K', 'Y': 'L', 'Z': 'M',
            "0": "5", "1": "6", "2": "7", "3": "8", "4": "9", "5": "0", "6": "1", "7": "2", "8": "3", "9": "4"}
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [ROT 18]
ROT 18 ist eigentlich nix anderes als, daß hier ROT 5
mit ROT 13 kombiniert wird. Die Buchstaben A-Z werden
um 13 Stellen verschoben und die Ziffern 0-9 um 5 Stellen.
Alle sonstigen Zeichen bleiben unverändert und die Kleine-
oder Großschreibung bleibt auch erhalten, und auch hier
kodiert/dekodiert ein und dieselbe Funktion.""" + "\n\n")
    else:
        atxt = ""
        for z in eingabetext:
            if z.upper() not in ro18:
                atxt = atxt + z
            elif z.lower() == z:
                a = ro18[z.upper()]
                atxt = atxt + a.lower()
            else:
                atxt = atxt + ro18[z.upper()]
        Ausgabe.insert(1.0, atxt + "\n")


def rot47():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [ROT 47]
Bei ROT47 geschieht eigentlich nix anderes als
bei ROT5 oder ROT13 nur das hier die druckbaren
ASCII-Zeichen mit den Werten 33-126(dezimal) zur
Auswahl stehen, also nahezu alle Zeichen die auf
eine Standardtastatur aufgedruckt sind.
Das Ergebnis ist aber deutlich unlesbarer als
z.B. bei ROT13. Alle weiteren Zeichen (z.B. ÄÖÜß)
werden unverändert wiedergegeben und auch hier
kodiert/dekodiert ein und dieselbe Funktion.""" + "\n\n")
    else:
        x = []
        for i in eingabetext:
            j = ord(i)
            if 33 <= j <= 126:
                x.append(chr(33 + ((j + 14) % 94)))
            else:
                x.append(i)
        Ausgabe.insert(1.0, ''.join(x) + "\n")


def asciitodez():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Text zu Dezimalzahlen]
Der eingegebene Text wird in Dezimalzahlen umgewandelt. """ + "\n\n")
    else:
        z = []
        for i in eingabetext:
            z.append(str(ord(i)))
        Ausgabe.insert(1.0, ' '.join(z) + "\n")


def deztoascii():
    seperator = ("|,", "_", ".", "-", "/", ";", ",")
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Dezimalzahlen zu Text]
Die eingegebenen Dezimalzahlen werden in die
entsprechenden UNICODE-Zeichen umgewandelt.
Als Trennungszeichen zwischen den Zahlen sind
folgende Zeichen erlaubt: | , _ . - / ; , und 
Leerzeichen. Bei Verwendung von Leerzeichen
sollten möglichst nur 1 Leerzeichen zwischen
den Zahlen verwendet werden (überzählige
Leerzeichen werden sonst als nicht erkannte
Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; . / - _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                Ausgabe.insert(1.0, chr(ausz) + "\n")
        else:
            txt = eingabetext.split(se)
            atxt = ""
            ignor = ""
            for z in txt:
                try:
                    az = int(z)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    atxt = atxt + chr(az)
            Ausgabe.insert(1.0, atxt + "\n")
            Ausgabe.insert(1.0, "umgewandelte Zeichen:\n", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung nicht erkannte Zeichen:\n", "re")


def asciitohex():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Text zu Hexadezimalzahlen]
Der eingegebene Text wird in Hexadezimalzahlen umgewandelt. """ + "\n\n")
    else:
        z = []
        for i in eingabetext:
            hexstr = ("{:X}".format(ord(i)))  # großes X für Hex in Großbuchstaben
            z.append(hexstr)
        Ausgabe.insert(1.0, ' '.join(z) + "\n")


def hextoascii():
    seperator = ("|,", "_", ".", "-", "/", ";", ",")
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Hexadezimalzahlen zu Text]
Die eingegebenen Hexadezimalzahlen werden in die
entsprechenden UNICODE-Zeichen umgewandelt.
Als Trennungszeichen zwischen den Zahlen sind
folgende Zeichen erlaubt: | , _ . - / ; , und 
Leerzeichen. Bei Verwendung von Leerzeichen
sollten möglichst nur 1 Leerzeichen zwischen
den Zahlen verwendet werden (überzählige
Leerzeichen werden sonst als nicht erkannte
Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext, 16)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; . / - _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                Ausgabe.insert(1.0, chr(ausz) + "\n")
        else:
            txt = eingabetext.split(se)
            atxt = ""
            ignor = ""
            for z in txt:
                try:
                    az = int(z, 16)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    atxt = atxt + chr(az)
            Ausgabe.insert(1.0, atxt + "\n")
            Ausgabe.insert(1.0, "umgewandelte Zeichen:\n", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung nicht erkannte Zeichen:\n", "re")


def asciitooctal():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Text zu Octalzahlen]
Der eingegebene Text wird in Octalzahlen umgewandelt. """ + "\n\n")
    else:
        z = []
        for i in eingabetext:
            z.append("{:o}".format(ord(i)))
        Ausgabe.insert(1.0, ' '.join(z) + "\n")


def octaltoascii():
    seperator = ("|,", "_", ".", "-", "/", ";", ",")
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Octalzahlen zu Text]
Die eingegebenen Octalzahlen werden in die
entsprechenden UNICODE-Zeichen umgewandelt.
Als Trennungszeichen zwischen den Zahlen sind
folgende Zeichen erlaubt: | , _ . - / ; , und 
Leerzeichen. Bei Verwendung von Leerzeichen
sollten möglichst nur 1 Leerzeichen zwischen
den Zahlen verwendet werden (überzählige
Leerzeichen werden sonst als nicht erkannte
Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext, 8)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; . / - _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                Ausgabe.insert(1.0, chr(ausz) + "\n")
        else:
            txt = eingabetext.split(se)
            atxt = ""
            ignor = ""
            for z in txt:
                try:
                    az = int(z, 8)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    atxt = atxt + chr(az)
            Ausgabe.insert(1.0, atxt + "\n")
            Ausgabe.insert(1.0, "umgewandelte Zeichen:\n", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung nicht erkannte Zeichen:\n", "re")


def asciitobin16():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Text zu Binärzahlen]
Der eingegebene Text wird in Binärzahlen mit
einer festgelegten Breite von 16bit (16 Zeichen)
umgewandelt. """ + "\n\n")
    else:
        z = []
        for i in eingabetext:
            z.append("{:0>16b}".format(ord(i)))
        Ausgabe.insert(1.0, ' '.join(z) + "\n")


def asciitobin8():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Text zu Binärzahlen]
Der eingegebene Text wird in Binärzahlen mit
einer festgelegten Breite von 8bit (8 Zeichen)
umgewandelt. """ + "\n\n")
    else:
        z = []
        for i in eingabetext:
            if ord(i) > 255:
                Ausgabe.insert(1.0,
                               "Sorry der Eingabetext enthält Zeichen,\nwelche sich nicht"
                               " mit 8 bit in binär darstellen lassen!\n")
                return
            z.append("{:0>8b}".format(ord(i)))
        Ausgabe.insert(1.0, ' '.join(z) + "\n")


def bintoascii():
    seperator = ("|,", "_", ".", "-", "/", ";", ",")
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Binärzahlen zu Text]
Die eingegebenen Binärzahlen werden in die
entsprechenden UNICODE-Zeichen umgewandelt.
Als Trennungszeichen zwischen den Zahlen sind
folgende Zeichen erlaubt: | , _ . - / ; , und 
Leerzeichen. Bei Verwendung von Leerzeichen
sollten möglichst nur 1 Leerzeichen zwischen
den Zahlen verwendet werden (überzählige
Leerzeichen werden sonst als nicht erkannte
Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext, 2)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; . / - _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                Ausgabe.insert(1.0, chr(ausz) + "\n")
        else:
            txt = eingabetext.split(se)
            atxt = ""
            ignor = ""
            for z in txt:
                try:
                    az = int(z, 2)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    atxt = atxt + chr(az)
            Ausgabe.insert(1.0, atxt + "\n")
            Ausgabe.insert(1.0, "umgewandelte Zeichen:\n", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung nicht erkannte Zeichen:\n", "re")


def zahlwortsuche_de():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Zahlwortsuche DE 0-12]
Diese Funktion versucht deutsche Zahlworte
zwischen 0 und 12 in einem Text aufzuspüren.
Da alle Zeichen ignoriert werden, welche
keine Buchstaben sind, werden auch Zahlwörter
gefunden welche sich z.B. über zwei Worte
verteilen.""" + "\n\n")
    else:
        zahlen = ["null", "eins", "zwei", "drei", "vier", "fünf", "fuenf", "sechs", "sieben", "acht",
                  "neun", "zehn", "elf", "zwölf", "zwoelf", "zwanzig", "hundert", "tausend"]
        ntxt = ""
        abc = "abcdefghijklmnopqrstuvwxyzäöüß"
        for b in eingabetext:
            if b.lower() not in abc:
                continue
            ntxt = ntxt + b.lower()
        for z in zahlen:
            if z.lower() in ntxt:
                ntxt = ntxt.replace(z.lower(), "-" + z.upper() + "_")
        atxt = ""
        tt = False
        for b in ntxt:
            if b == "-":
                tt = True
                continue
            if b == "_":
                tt = False
                atxt = atxt + " "
            if tt:
                atxt = atxt + b
        if atxt == "":
            Ausgabe.insert(1.0, "Leider keine Zahlwörter gefunden!\n", "re")
        else:
            Ausgabe.insert(1.0, ntxt + "\n")
            Ausgabe.insert(1.0, "Eingangstext:", "bu")
            Ausgabe.insert(1.0, atxt + "\n\n")
            Ausgabe.insert(1.0, "Gefundene Zahlwörter:", "bu")


def zahlwortsuche_en():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Zahlwortsuche EN 0-15]
Diese Funktion versucht englische Zahlworte
zwischen 0 und 15 in einem Text aufzuspüren.
Da alle Zeichen ignoriert werden, welche
keine Buchstaben sind, werden auch Zahlwörter
gefunden welche sich z.B. über zwei Worte
verteilen.""" + "\n\n")
    else:
        zahlen = ["eleven", "twelve", "thirteen", "fourteen", "fifteen", "fourty", "sixty", "seventy",
                  "eighty", "ninety", "zero", "one", "two", "three", "four", "five", "six", "seven",
                  "eight", "nine", "ten", "twenty", "thirty", "fifty"]
        ntxt = ""
        abc = "abcdefghijklmnopqrstuvwxyz"
        for b in eingabetext:
            if b.lower() not in abc:
                continue
            ntxt = ntxt + b.lower()
        for z in zahlen:
            if z.lower() in ntxt:
                ntxt = ntxt.replace(z.lower(), "-" + z.upper() + "_")
        atxt = ""
        tt = False
        for b in ntxt:
            if b == "-":
                tt = True
                continue
            if b == "_":
                tt = False
                atxt = atxt + " "
            if tt:
                atxt = atxt + b
        if atxt == "":
            Ausgabe.insert(1.0, "Leider keine Zahlwörter gefunden!\n", "re")
        else:
            Ausgabe.insert(1.0, ntxt + "\n")
            Ausgabe.insert(1.0, "Eingangstext:", "bu")
            Ausgabe.insert(1.0, atxt + "\n\n")
            Ausgabe.insert(1.0, "Gefundene Zahlwörter:", "bu")


def kenny_kodieren():
    alphabet = {"a": "mmm", "b": "mmp", "c": "mmf", "d": "mpm", "e": "mpp", "f": "mpf", "g": "mfm", "h": "mfp",
                "i": "mff", "j": "pmm", "k": "pmp",
                "l": "pmf", "m": "ppm", "n": "ppp", "o": "ppf", "p": "pfm", "q": "pfp", "r": "pff", "s": "fmm",
                "t": "fmp", "u": "fmf", "v": "fpm", "w": "fpp",
                "x": "fpf", "y": "ffm", "z": "ffp", "ä": "mmmmpp", "ö": "ppfmpp", "ü": "fmfmpp", "ß": "fmmfmm",
                "A": "Mmm", "B": "Mmp", "C": "Mmf", "D": "Mpm",
                "E": "Mpp", "F": "Mpf", "G": "Mfm", "H": "Mfp", "I": "Mff", "J": "Pmm", "K": "Pmp", "L": "Pmf",
                "M": "Ppm", "N": "Ppp", "O": "Ppf", "P": "Pfm",
                "Q": "Pfp", "R": "Pff", "S": "Fmm", "T": "Fmp", "U": "Fmf", "V": "Fpm", "W": "Fpp", "X": "Fpf",
                "Y": "Ffm", "Z": "Ffp", "Ä": "Mmmmpp",
                "Ö": "Ppfmpp", "Ü": "Fmfmpp"
                }
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Kennyspeak codieren]
Hilfe sie haben Kenny getötet.. ach nee er kann
ja noch seine unverständlichen m p f -Laute von
sich geben und hier geht es darum normalen
Text in genau diese Laute umzusetzen, wo jedem
Buchstaben A-Z eine 3 Zeichen-Kombination
zugeordnet ist die sich aus m,p,f 
zusammensetzt.(a=mmm h=mfp x=fpf)""" + "\n\n")
    else:
        atxt = ""
        for b in eingabetext:
            if b in alphabet:
                atxt = atxt + alphabet[b]
            else:
                atxt = atxt + b
        Ausgabe.insert(1.0, atxt + "\n")


def unkennify(text):
    # Funktion hier entnommen und angepasst: https://www.namesuppressed.com/software/kenny.py
    decoded = ''
    codemap = str.maketrans('MmPpFf', '001122')
    n_len = len(text)
    i = 0
    while i + 3 <= n_len:
        if match('[MmPpFf]{3,}', text[i:i + 3]):
            num = int(text[i:i + 3].translate(codemap), 3)  # 'mpf' -> '012' -> 5
            cypher = chr(num + ord('a'))  # 5 -> 'f'
            if text[i].isupper():
                cypher = cypher.upper()
            decoded = decoded + cypher
            i = i + 3
        else:
            decoded = decoded + text[i]
            i = i + 1
    if i < n_len:
        decoded = decoded + text[i:]
    return decoded


def kenny_dekodieren():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Kennyspeak decodieren]
Wie? Du verstehst Kenny's mpf-Gebrabbel nicht?
Na gut da kann ich helfen!!
Nicht kennifiziertes wird unverändert ausgegeben.""" + "\n\n")
    else:
        Ausgabe.insert(1.0, unkennify(eingabetext) + "\n")


def kenny_raten():
    wbk = {"000": "a", "001": "b", "002": "c", "010": "d", "011": "e", "012": "f", "020": "g", "021": "h",
           "022": "i", "100": "j", "101": "k", "102": "l", "110": "m", "111": "n", "112": "o", "120": "p",
           "121": "q", "122": "r", "200": "s", "201": "t", "202": "u", "210": "v", "211": "w", "212": "x",
           "220": "y", "221": "z"
           }
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [KENNYspeak raten]
Diese Funktion dient zum dekodieren von kennyfizierten
Texten, bei denen die 3 Buchstaben mpf vertauscht oder durch
andere Zeichen ersetzt wurden. Hierzu werden vor der
Dekodierung die 3 häufigsten Zeichen im Text ermittelt und
alle anderen Zeichen entfernt bevor die 6 möglichen Lösungen
ausgegeben werden.
(Falls zum kodieren die Zahlen 0,1 oder 2 verwendet wurden,
werden sie durch Buchstaben a,b,c.. ersetzt)""" + "\n\n")
    else:
        wtxt = ""
        for b in eingabetext:
            if b == chr(9) or b == chr(32) or b == chr(10):
                continue  # erstmal leerzeichen, tab, linefeed raus
            wtxt = wtxt + b.lower()
        anzahl = {}  # restliche zeichen zählen und in ein wörterbuch
        for c in wtxt:
            if c in anzahl:
                anzahl[c] = anzahl[c] + 1
            else:
                anzahl[c] = 1
        s = []  # zum Sortieren lieber eine liste
        for key in anzahl:
            s.append([anzahl[key], key])
        s.sort(reverse=True)
        abc3 = [s[0][1], s[1][1], s[2][1]]  # die 3 häufigsten Zeichen im Text wären gefunden
        cwtxt = ""
        for b in wtxt:  # alles raus außer den 3 häufigsten Zeichen
            if b not in abc3:
                continue
            cwtxt = cwtxt + b
        abca = ["a", "b", "c", "d"]  # falls 0,1,2 verwendet wurden in a, b, c... ändern
        if "0" in abc3 or "1" in abc3 or "2" in abc3:
            for i in range(3):
                if abc3[i] in ["0", "1", "2"]:
                    for j in abca:
                        if j in abc3:
                            continue
                        else:
                            cwtxt = cwtxt.replace(abc3[i], j)
                            abc3[i] = j
                            break
        for p in all_perms(abc3):
            txt0 = cwtxt.replace(p[0], "0")
            txt1 = txt0.replace(p[1], "1")
            txt2 = txt1.replace(p[2], "2")
            atxt = ""
            for i in range(0, len(txt2), 3):
                tri = txt2[i:i + 3]
                if tri in wbk:
                    atxt = atxt + wbk[tri]
            Ausgabe.insert(1.0, "{}\n".format(atxt))
            Ausgabe.insert(1.0, "{}\n".format(p), "bu")


def primzahlalphabet_dekodieren():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Primzahlalphabet dekodieren]
Hier können Primzahlen kleiner als 1 Million
in Buchstaben umgewandelt werden. Es wird dabei
davon ausgegangen, daß den Primzahlen 
wiederholend die Buchstaben A-Z zugeordnet
werden,2=A 3=B 5=C 7=D 11=E.......
....97=Y 101=Z 103=A 107=B ... usw.""" + "\n\n")
    else:
        grenze = 1000000
        primes = primzahlliste(grenze)
        pdict = {}
        bz = 65
        for p in primes:
            if bz == 91:
                bz = 65
            pdict[p] = chr(bz)
            bz += 1
        seperator = ("|,", "_", ".", "-", "/", ";", ",")
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
            if se == "" and " " in eingabetext:
                se = " "
        if se == "":
            try:
                ausz = int(eingabetext)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; . / - _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                if ausz in pdict:
                    Ausgabe.insert(1.0, pdict[ausz] + "\n")
                else:
                    Ausgabe.insert(1.0, eingabetext + " ist keine Primzahl oder größer als 1 Million!\n")
        else:
            txt = eingabetext.split(se)
            atxt = ""
            ignor = ""
            for z in txt:
                try:
                    az = int(z)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    if az in pdict:
                        atxt = atxt + pdict[az]
                    else:
                        ignor = ignor + str(z) + " "
            Ausgabe.insert(1.0, atxt + "\n")
            Ausgabe.insert(1.0, "umgewandelte Zahlen:\n", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "ignoriert wurde:\n", "re")


def primzahlpruefen():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Primzahl prüfen]
Für eine eingegebene Zahl wird überprüft,
ob es sich um eine Primzahl handelt.
Ist die eingegebene Zahl eine Primzahl
wird auch informiert, die wievielte
Primzahl es ist.
Zahlen über 1299709 (der 100000. Primzahl)
werden abgelehnt.""" + "\n\n")
    else:
        try:
            ausz = int(eingabetext)
        except ValueError:
            Ausgabe.insert(1.0, "Keine Zahl erkannt!\n", "re")
        else:
            if ausz > 1299709:
                Ausgabe.insert(1.0,
                               "Sorry, aber ich mag nur die ersten 100000 Primzahlen,\ndas sind Zahlen"
                               " bis maximal 1299709 !\n", "re")
                return
            primes = primzahlliste(1299710)
            if ausz not in primes:
                Ausgabe.insert(1.0, "{} ist keine Primzahl\n".format(ausz))
            else:
                Ausgabe.insert(1.0, "{} ist die {}. Primzahl\n".format(ausz, primes.index(ausz) + 1))


def nte_primzahl():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [n.te Primzahl]
Du willst wissen wie z.B. die 1000. Primzahl lautet,
dann bist du hier genau richtig.
Die Funktion liefert maximal die 100000. Primzahl.
""" + "\n\n")
    else:
        try:
            ausz = int(eingabetext)
        except ValueError:
            Ausgabe.insert(1.0, "Keine Zahl erkannt!\n", "re")
        else:
            if ausz > 100000:
                Ausgabe.insert(1.0,
                               "Sorry, aber ich mag nur die ersten 100000 Primzahlen,\ndas sind Zahlen bis"
                               " maximal 1299709 !\n", "re")
                return
            primes = primzahlliste(1299710)
            Ausgabe.insert(1.0, "Die {}. Primzahl lautet:{}\n".format(ausz, primes[ausz - 1]))


def primfaktoren():
    hilfetext = """HILFE: [Primfaktorenzerlegung]
Für die eingegebene Zahl werden die Primfaktoren ermittelt
und ausgegeben. Sollte die Zahl einen Primfaktoren haben, welcher
größer als 100 Millionen ist, wird die Suche abgebrochen, da die
Suche sonst zu lange dauert.
Die Funktion läßt sich damit also auch, bei Zahlen kleiner als 200 
Millionen, dazu benutzen um festzustellen, ob die eingegebene Zahl eine
Primzahl ist.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            n = int(eingabetext)
        except ValueError:
            Ausgabe.insert(1.0, "Es konnte leider keine Zahl erkannt werden.\n", "re")
            return
        faktoren = []
        for i in chain([2], range(3, n // 2 + 1, 2)):
            if i > 100000000:
                Ausgabe.insert(1.0,
                               "Sorry, aber die Primfaktorensuche wurde abgebrochen,\nda mindestens 1 Faktor"
                               " größer als 100 Millionen ist.\n", "re")
                return
            while n % i == 0:
                faktoren.append(i)
                n = n // i
            if i > n:
                break
        out = "Die Zahl {} hat folgende Primfaktoren:\n".format(eingabetext)
        if not faktoren:
            Ausgabe.insert(1.0, "Die Zahl {} ist eine Primzahl!!\n".format(eingabetext))
        else:
            for z in faktoren:
                out += str(z) + ", "
        return Ausgabe.insert(1.0, out[:-2] + "\n")


def deztohexoctbin():
    seperator = ("|,", "_", "/", ";", ",")
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Dezimal zu HEX, Octal, Binär]
Die eingegebenen dezimalen Ganzzahlen werden in die
entsprechenden hexadezimalen, octalen und binären
Zahlen umgerechnet.
Als Trennungszeichen zwischen den Zahlen sind
folgende Zeichen erlaubt: | , _ / ; , und 
Leerzeichen. Bei Verwendung von Leerzeichen
sollten möglichst nur 1 Leerzeichen zwischen
den Zahlen verwendet werden (überzählige
Leerzeichen werden sonst als nicht erkannte
Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; / _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                Ausgabe.insert(1.0, "Dez: {0:} HEX:{0:X} OCT:{0:o} BIN:{0:b}\n".format(ausz))
        else:
            txt = eingabetext.split(se)
            deztxt, hextxt, octtxt, bintxt, ignor = "", "", "", "", ""
            for z in txt:
                try:
                    az = int(z)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    deztxt = deztxt + str(az) + "/"
                    hextxt = hextxt + "{:X}".format(az) + "/"
                    octtxt = octtxt + "{:o}".format(az) + "/"
                    bintxt = bintxt + "{:b}".format(az) + "/"
            Ausgabe.insert(1.0, bintxt[:-1] + "\n")
            Ausgabe.insert(1.0, "BIN:", "bu")
            Ausgabe.insert(1.0, octtxt[:-1] + "\n")
            Ausgabe.insert(1.0, "OCT:", "bu")
            Ausgabe.insert(1.0, hextxt[:-1] + "\n")
            Ausgabe.insert(1.0, "HEX:", "bu")
            Ausgabe.insert(1.0, deztxt[:-1] + "\n")
            Ausgabe.insert(1.0, "DEZ:", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung nicht erkannte Zeichen:", "re")


def hextodezoctbin():
    seperator = ("|,", "_", "/", ";", ",")
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Hexadezimal zu Dezimal, Octal, Binär]
Die eingegebenen hexadezimalen Zahlen werden in die
entsprechenden dezimalen, octalen und binären
Zahlen umgerechnet.
Als Trennungszeichen zwischen den Zahlen sind
folgende Zeichen erlaubt: | , _ / ; , und 
Leerzeichen. Bei Verwendung von Leerzeichen
sollten möglichst nur 1 Leerzeichen zwischen
den Zahlen verwendet werden (überzählige
Leerzeichen werden sonst als nicht erkannte
Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext, 16)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; / _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                Ausgabe.insert(1.0, "HEX:{0:X} Dez: {0:} OCT:{0:o} BIN:{0:b}\n".format(ausz))
        else:
            txt = eingabetext.split(se)
            deztxt, hextxt, octtxt, bintxt, ignor = "", "", "", "", ""
            for z in txt:
                try:
                    az = int(z, 16)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    deztxt = deztxt + str(az) + "/"
                    hextxt = hextxt + "{:X}".format(az) + "/"
                    octtxt = octtxt + "{:o}".format(az) + "/"
                    bintxt = bintxt + "{:b}".format(az) + "/"
            Ausgabe.insert(1.0, bintxt[:-1] + "\n")
            Ausgabe.insert(1.0, "BIN:", "bu")
            Ausgabe.insert(1.0, octtxt[:-1] + "\n")
            Ausgabe.insert(1.0, "OCT:", "bu")
            Ausgabe.insert(1.0, deztxt[:-1] + "\n")
            Ausgabe.insert(1.0, "DEZ:", "bu")
            Ausgabe.insert(1.0, hextxt[:-1] + "\n")
            Ausgabe.insert(1.0, "HEX:", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung nicht erkannte Zeichen:", "re")


def octtohexdezbin():
    seperator = ("|,", "_", "/", ";", ",")
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Octal zu HEX, Dezimal, Binär]
Die eingegebenen octalen Zahlen werden in die
entsprechenden hexadezimalen, dezimalen und binären
Zahlen umgerechnet.
Als Trennungszeichen zwischen den Zahlen sind
folgende Zeichen erlaubt: | , _ / ; , und 
Leerzeichen. Bei Verwendung von Leerzeichen
sollten möglichst nur 1 Leerzeichen zwischen
den Zahlen verwendet werden (überzählige
Leerzeichen werden sonst als nicht erkannte
Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext, 8)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; / _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                Ausgabe.insert(1.0, "OCT:{0:o} HEX:{0:X} Dez: {0:} BIN:{0:b}\n".format(ausz))
        else:
            txt = eingabetext.split(se)
            deztxt, hextxt, octtxt, bintxt, ignor = "", "", "", "", ""
            for z in txt:
                try:
                    az = int(z, 8)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    deztxt = deztxt + str(az) + "/"
                    hextxt = hextxt + "{:X}".format(az) + "/"
                    octtxt = octtxt + "{:o}".format(az) + "/"
                    bintxt = bintxt + "{:b}".format(az) + "/"
            Ausgabe.insert(1.0, bintxt[:-1] + "\n")
            Ausgabe.insert(1.0, "BIN:", "bu")
            Ausgabe.insert(1.0, deztxt[:-1] + "\n")
            Ausgabe.insert(1.0, "DEZ:", "bu")
            Ausgabe.insert(1.0, hextxt[:-1] + "\n")
            Ausgabe.insert(1.0, "HEX:", "bu")
            Ausgabe.insert(1.0, octtxt[:-1] + "\n")
            Ausgabe.insert(1.0, "OCT:", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung nicht erkannte Zeichen:", "re")


def bintohexdezoct():
    seperator = ("|,", "_", "/", ";", ",")
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Binär zu HEX, Dezimal, Octal]
Die eingegebenen binären Zahlen werden in die
entsprechenden hexadezimalen, dezimalen und octalen
Zahlen umgerechnet.
Als Trennungszeichen zwischen den Zahlen sind
folgende Zeichen erlaubt: | , _ / ; , und 
Leerzeichen. Bei Verwendung von Leerzeichen
sollten möglichst nur 1 Leerzeichen zwischen
den Zahlen verwendet werden (überzählige
Leerzeichen werden sonst als nicht erkannte
Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext, 2)
            except ValueError:
                Ausgabe.insert(1.0, "Keine Zahl oder gültiges Trennzeichen (, ; / _ | oder Leerzeichen) erkannt!\n",
                               "re")
            else:
                Ausgabe.insert(1.0, "BIN:{0:b} HEX:{0:X} Dez: {0:} OCT:{0:o}\n".format(ausz))
        else:
            txt = eingabetext.split(se)
            deztxt, hextxt, octtxt, bintxt, ignor = "", "", "", "", ""
            for z in txt:
                try:
                    az = int(z, 2)
                except ValueError:
                    ignor = ignor + str(z) + " "
                else:
                    deztxt = deztxt + str(az) + "/"
                    hextxt = hextxt + "{:X}".format(az) + "/"
                    octtxt = octtxt + "{:o}".format(az) + "/"
                    bintxt = bintxt + "{:b}".format(az) + "/"
            Ausgabe.insert(1.0, octtxt[:-1] + "\n")
            Ausgabe.insert(1.0, "OCT:", "bu")
            Ausgabe.insert(1.0, deztxt[:-1] + "\n")
            Ausgabe.insert(1.0, "DEZ:", "bu")
            Ausgabe.insert(1.0, hextxt[:-1] + "\n")
            Ausgabe.insert(1.0, "HEX:", "bu")
            Ausgabe.insert(1.0, bintxt[:-1] + "\n")
            Ausgabe.insert(1.0, "BIN:", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung nicht erkannte Zeichen:", "re")


def abctotomtom():
    alphabet = {"a": "/ ", "b": "// ", "c": "/// ", "d": "//// ", "e": "/\\ ", "f": "//\\ ", "g": "///\\ ",
                "h": "/\\\\ ",
                "i": "/\\\\\\ ", "j": "\\/ ", "k": "\\\\/ ", "l": "\\\\\\/ ", "m": "\\// ", "n": "\\/// ", "o": "/\\/ ",
                "p": "//\\/ ",
                "q": "/\\\\/ ", "r": "/\\// ", "s": "\\/\\ ", "t": "\\\\/\\ ", "u": "\\//\\ ", "v": "\\/\\\\ ",
                "w": "//\\\\ ",
                "x": "\\\\// ", "y": "\\/\\/ ", "z": "/\\/\\ "
                }  # jweils doppelte backslashs da python sonst als versucht Escapecodes draus zu machen \\ = \
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Text zu Tomtom]
Beim Tomtom Code werden die einzelnen Buchstaben durch
Kombinationen von / und \\ dargestellt. Zwischen den
einzelnen Buchstaben steht ein Leerzeichen zwischen Worten
zwei Leerzeichen. Kodiert werden, können nur die 
Buchstaben A-Z.""" + "\n\n")
    else:
        atxt = ""
        ignor = ""
        for b in eingabetext:
            if b == " ":
                atxt = atxt + "  "
            elif b.lower() not in alphabet:
                ignor = ignor + b + " "
            else:
                atxt = atxt + alphabet[b.lower()]
        Ausgabe.insert(1.0, atxt + "\n")
        Ausgabe.insert(1.0, "kodierter Text:", "bu")
        if ignor != "":
            Ausgabe.insert(1.0, ignor + "\n")
            Ausgabe.insert(1.0, "ignorierte Zeichen:", "re")


def tomtomtoabc():
    alphabet = {'/': 'A', '//': 'B', '///': 'C', '////': 'D', '/\\': 'E', '//\\': 'F', '///\\': 'G', '/\\\\': 'H',
                '/\\\\\\': 'I', '\\/': 'J',
                '\\\\/': 'K', '\\\\\\/': 'L', '\\//': 'M', '\\///': 'N', '/\\/': 'O', '//\\/': 'P', '/\\\\/': 'Q',
                '/\\//': 'R', '\\/\\': 'S',
                '\\\\/\\': 'T', '\\//\\': 'U', '\\/\\\\': 'V', '//\\\\': 'W', '\\\\//': 'X', '\\/\\/': 'Y',
                '/\\/\\': 'Z'
                }  # jeweils doppelte backslashs da python sonst versucht Escapecodes draus zu machen \\ = \
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Tomtom zu Text]
Beim Tomtom Code werden die einzelnen Buchstaben durch
Kombinationen von / und \\ dargestellt. Zwischen den
einzelnen Buchstaben steht ein Leerzeichen zwischen Worten
zwei Leerzeichen. Kodiert werden, können nur die 
Buchstaben A-Z.""" + "\n\n")
    else:
        tomtom = eingabetext.replace("  ", " _ ")
        tomtom = tomtom.split()
        atxt = ""
        for sign in tomtom:
            if sign == "_":
                atxt = atxt + " "
            elif sign not in alphabet:
                atxt = atxt + "#"
            else:
                atxt = atxt + alphabet[sign]
        Ausgabe.insert(1.0, atxt + "\n")


def texttoslashpipe():
    alphabet = {"a": "| ", "b": "|\\ ", "c": "|| ", "d": "|/ ", "e": "\\ ", "f": "||\\ ", "g": "||| ", "h": "\\\\ ",
                "i": "/ ", "j": "|\\\\ ", "k": "//|| ", "l": "|\\/ ", "m": "|\\| ", "n": "|/| ", "o": "||/| ",
                "p": "|\\|\\ ",
                "q": "/\\ ", "r": "\\/ ", "s": "/| ", "t": "|// ", "u": "// ", "v": "||\\\\ ", "w": "\\/|| ",
                "x": "||/ ", "y": "|||\\ ", "z": "|||| "
                }  # jweils doppelte backslashs da python sonst versucht Escapecodes draus zu machen \\ = \
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Text zu Slash and Pipe]
Vergleichbar mit dem Tomtom-Code nur das hier für die
Buchstabenkodierung auch der | mit eingesetzt wird. 
Zwischen den einzelnen Buchstaben steht ein Leerzeichen
zwischen Worten zwei Leerzeichen.
Kodiert werden, können nur die Buchstaben A-Z.""" + "\n\n")
    else:
        atxt = ""
        ignor = ""
        for b in eingabetext:
            if b == " ":
                atxt = atxt + "  "
            elif b.lower() not in alphabet:
                ignor = ignor + b + " "
            else:
                atxt = atxt + alphabet[b.lower()]
        Ausgabe.insert(1.0, atxt + "\n")
        Ausgabe.insert(1.0, "kodierter Text:", "bu")
        if ignor != "":
            Ausgabe.insert(1.0, ignor + "\n")
            Ausgabe.insert(1.0, "ignorierte Zeichen:", "re")


def slashpipetotext():
    alphabet = {'|': 'A', '|\\': 'B', '||': 'C', '|/': 'D', '\\': 'E', '||\\': 'F', '|||': 'G', '\\\\': 'H', '/': 'I',
                '|\\\\': 'J', '//||': 'K', '|\\/': 'L', '|\\|': 'M', '|/|': 'N', '||/|': 'O', '|\\|\\': 'P', '/\\': 'Q',
                '\\/': 'R',
                '/|': 'S', '|//': 'T', '//': 'U', '||\\\\': 'V', '\\/||': 'W', '||/': 'X', '|||\\': 'Y', '||||': 'Z'}
    # jeweils doppelte backslashs da python sonst versucht Escapecodes draus zu machen \\ = \
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Slash and Pipe zu Text]
Vergleichbar mit dem Tomtom-Code nur das hier für die
Buchstabenkodierung auch der | mit eingesetzt wird. 
Zwischen den einzelnen Buchstaben steht ein Leerzeichen
zwischen Worten zwei Leerzeichen.
Kodiert werden, können nur die Buchstaben A-Z.""" + "\n\n")
    else:
        tomtom = eingabetext.replace("  ", " _ ")
        tomtom = tomtom.split()
        atxt = ""
        for sign in tomtom:
            if sign == "_":
                atxt = atxt + " "
            elif sign not in alphabet:
                atxt = atxt + "#"
            else:
                atxt = atxt + alphabet[sign]
        Ausgabe.insert(1.0, atxt + "\n")


def periodensystem():
    seperator = ("|,", "_", ".", "-", "/", ";", ",")
    pse = {1: "H", 2: "He", 3: "Li", 4: "Be", 5: "B", 6: "C", 7: "N", 8: "O", 9: "F", 10: "Ne", 11: "Na", 12: "Mg",
           13: "Al",
           14: "Si", 15: "P", 16: "S", 17: "Cl", 18: "Ar", 19: "K", 20: "Ca", 21: "Sc", 22: "Ti", 23: "V", 24: "Cr",
           25: "Mn",
           26: "Fe", 27: "Co", 28: "Ni", 29: "Cu", 30: "Zn", 31: "Ga", 32: "Ge", 33: "As", 34: "Se", 35: "Br", 36: "Kr",
           37: "Rb", 38: "Sr", 39: "Y", 40: "Zr", 41: "Nb", 42: "Mo", 43: "Tc", 44: "Ru", 45: "Rh", 46: "Pd", 47: "Ag",
           48: "Cd", 49: "In", 50: "Sn", 51: "Sb", 52: "Te", 53: "I", 54: "Xe", 55: "Cs", 56: "Ba", 57: "La", 58: "Ce",
           59: "Pr", 60: "Nd", 61: "Pm", 62: "Sm", 63: "Eu", 64: "Gd", 65: "Tb", 66: "Dy", 67: "Ho", 68: "Er", 69: "Tm",
           70: "Yb", 71: "Lu", 72: "Hf", 73: "Ta", 74: "W", 75: "Re", 76: "Os", 77: "Ir", 78: "Pt", 79: "Au", 80: "Hg",
           81: "Tl", 82: "Pb", 83: "Bi", 84: "Po", 85: "At", 86: "Rn", 87: "Fr", 88: "Ra", 89: "Ac", 90: "Th", 91: "Pa",
           92: "U", 93: "Np", 94: "Pu", 95: "Am", 96: "Cm", 97: "Bk", 98: "Cf", 99: "Es", 100: "Fm", 101: "Md",
           102: "No",
           103: "Lr", 104: "Rf", 105: "Db", 106: "Sg", 107: "Bh", 108: "Hs", 109: "Mt", 110: "Ds", 111: "Rg", 112: "Cn",
           113: "Nh", 114: "Fl", 115: "Mc", 116: "Lv", 117: "Ts", 118: "Og"}
    um_pse = {v: k for k, v in pse.items()}
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Periodensystem: Ordnungszahl<->Symbol]
Eingegebenen Ordnungszahlen 1-118 aus dem Periodensystem der
Elemente werden in die ihnen zugehörigen Elementsymbole umgewandelt
und anschließend als Text ausgegeben, außerdem erscheint noch eine
Ausgabe bei welcher nur die Anfangsbuchstaben der Symbole ausgegeben
werden.
Werden in der Eingabe Symbole (z.B. N, He) erkannt werde diese
zusammen mit ihren Ordnungszahlen ausgegeben.
Als Trennungszeichen zwischen den Zahlen und/oder Symbolen sind
folgende Zeichen erlaubt: | , _ . - / ; , und Leerzeichen. 
Bei Verwendung von Leerzeichen sollten möglichst nur 1 Leerzeichen
zwischen den Zahlen verwendet werden (überzählige Leerzeichen werden
sonst als nicht erkannte Zeichen behandelt).""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            try:
                ausz = int(eingabetext)
            except ValueError:
                if eingabetext in um_pse:
                    Ausgabe.insert(1.0, str(um_pse[eingabetext]) + "\n")
                else:
                    Ausgabe.insert(1.0, "Keine gültige Eingabe erkannt!\n", "re")
            else:
                Ausgabe.insert(1.0, pse[ausz] + "\n")
        else:
            txt = eingabetext.split(se)
            atxt = ""
            atxt2 = ""
            atxt3 = ""
            ignor = ""
            for z in txt:
                try:
                    az = int(z)
                except ValueError:
                    if z in um_pse:
                        atxt3 += z + ":" + str(um_pse[z]) + " "
                    else:
                        ignor = ignor + z + " "
                else:
                    if az in pse:
                        atxt = atxt + pse[az]
                        atxt2 = atxt2 + pse[az][0]
                    else:
                        ignor = ignor + z + " "
            if atxt3 != "":
                Ausgabe.insert(1.0, " " + atxt3 + "\n")
                Ausgabe.insert(1.0, "Symbol:Ordnungszahl:", "bu")
            if atxt2 != "":
                Ausgabe.insert(1.0, " " + atxt2 + "\n")
                Ausgabe.insert(1.0, "Nur Anfangsbuchstaben:", "bu")
            if atxt != "":
                Ausgabe.insert(1.0, " " + atxt + "\n")
                Ausgabe.insert(1.0, "Symbole:", "bu")
            if ignor != "":
                Ausgabe.insert(1.0, ignor + "\n")
                Ausgabe.insert(1.0, "Achtung nicht erkannte Zeichen:\n", "re")


def brainfuck_interpreter():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Brainfuckinterpreter]
!!!!!ACHTUNG DIESE FUNKTION KANN DAS PROGRAMM ZUM ABSTURZ BRINGEN!!!!!
Brainfuck gehört zu den sogenannten esoterischen
Programmiersprachen. Der Programmcode setzt sich 
hier aus den 8 Zeichen ><+-.,[]' zusammen.
Diese Funktion führt einen derartigen Programmcode
aus, und gibt das Ergebnis aus, welches bei Geocaches
meist eine kurze Nachricht oder die Koordinaten sind.
Für eine umgekehrte Umwandlung von Text in Brainfuckcode
gibt es im Internet genügend Möglichkeiten zu finden.
Folgender Code wäre z.B. "Hello World!" in Brainfuck:
++++++++++[>+++++++>++++++++++>+++>+<<<<-]
>++.>+.+++++++..+++.>++.<<+++++++++++++++.
>.+++.------.--------.>+.>.""" + "\n\n")
    else:
        # ein kleiner feiner Code von https://gist.github.com/kates/986792
        c = [0] * 300000
        p = 0
        loop = []
        rv = []
        ts = list(eingabetext)
        li = len(ts)
        i = 0
        while i < li:
            t = ts[i]
            if t == ">":
                p += 1
            elif t == "<":
                p -= 1
            elif t == "+":
                c[p] += 1
            elif t == "-":
                c[p] -= 1
            elif t == ".":
                rv.append(chr(c[p]))
            elif t == ",":
                pass
            elif t == "[":
                if c[p] == 0:
                    while ts[i] != "]":
                        i += 1
                    loop.pop()
                else:
                    loop.append(i - 1)
            elif t == "]":
                i = loop[-1]
            i += 1
        Ausgabe.insert(1.0, "".join(rv) + "\n")


def ook_interpreter():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Ook-Interpreter]
!!!!!ACHTUNG DIESE FUNKTION KANN DAS PROGRAMM ZUM ABSTURZ BRINGEN!!!!!
Ook ist eine Abwandlung von Brainfuck wobei die 
8 Zeichen von Brainfuck hier durch eine Kombination
von je zwei der folgenden 3 Satzzeichen .!? ersetzt
werden. Dabei wird dann je das Wort Ook vor die Satzzeichen
geschrieben. z.B.: Ook! Ook? Ook. Ook!
Da Ook auch durch andere Wörter ersetzt oder auch
ganz ohne Wörter (ShortOok) auftaucht ignoriert diese
Funktion alle anderen Zeichen außer .!? bevor versucht wird
den Code auszuführen.""" + "\n\n")
    else:
        ookzeichen = [".", "!", "?"]
        ooktext = ""
        for z in eingabetext:  # erstmal Short-Ook draus machen
            if z in ookzeichen:
                ooktext = ooktext + z
        ookbf = {"..": "+", "!!": "-", ".?": ">", "?.": "<", "!?": "[", "?!": "]", "!.": ".", ".!": ","}
        bftext = ""
        for o in range(0, len(ooktext), 2):  # jetzt in Brainfuck umwandeln
            ooz = ooktext[o:o + 2]
            if ooz in ookbf:
                bftext = bftext + ookbf[ooz]
        c = [0] * 300000
        p = 0
        loop = []
        rv = []
        ts = list(bftext)
        li = len(ts)
        i = 0
        while i < li:
            t = ts[i]
            if t == ">":
                p += 1
            elif t == "<":
                p -= 1
            elif t == "+":
                c[p] += 1
            elif t == "-":
                c[p] -= 1
            elif t == ".":
                rv.append(chr(c[p]))
            elif t == ",":
                pass
            elif t == "[":
                if c[p] == 0:
                    while ts[i] != "]":
                        i += 1
                    loop.pop()
                else:
                    loop.append(i - 1)
            elif t == "]":
                i = loop[-1]
            i += 1
        Ausgabe.insert(1.0, "".join(rv) + "\n")


def naknaktotext():
    nakwb = {"Nak": "0", "Naknak": "6", "nanak": "B", "Nanak": "1", "Naknaknak": "7", "naknak": "C", "Nananak": "2",
             "Nak.": "8", "nak!": "D", "Nanananak": "3", "Naknak.": "9", "nak.": "E", "Nak?": "4", "Naknaknaknak": "A",
             "naknaknak": "F", "nak?": "5"}
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [NakNak to Text]
Nak-Nak / Entensprache / Duck Speak ist eine Spaßsprache,
welche vom Owner der Website schnatterente.net entwickelt 
wurde.
Diese Funktion übersetzt das Geschnatter in verständliche
Buchstaben/Zeichen.
!!Bitte unbedingt die Groß- und Kleinschreibung beibehalten!!
Wer diesen Quatsch unbedingt umgekehrt übersetzten will,
findet auf hier den passenden Übersetzer:
http://uebersetzer.schnatterente.net""" + "\n\n")
    else:
        txt = eingabetext.split()
        utxt = ""
        z = 1
        for nak in txt:
            if nak in nakwb and z == 1:
                utxt = utxt + "%" + nakwb[nak]
                z += 1
            elif nak in nakwb:
                utxt = utxt + nakwb[nak]
                z = 1
        atxt = urllib_parse_unquote(utxt)
        Ausgabe.insert(1.0, atxt + "\n")
        Ausgabe.insert(1.0, "dekodiertes Geschnatter:", "bu")


def navajototext():
    nabc = {"WOL-LA-CHEE": "A", "BE-LA-SANA": "A", "TSE-NILL": "A", "NA-HASH-CHID": "B", "SHUSH": "B", "TOISH-JEH": "B",
            "MOASI": "C", "TLA-GIN": "C", "BA-GOSHI": "C", "BE": "D", "CHINDI": "D", "LHA-CHA-EH": "D", "AH-JAH": "E",
            "DZEH": "E", "AH-NAH": "E", "CHUO": "F", "TSA-E-DONIN-EE": "F", "MA-E": "F", "AH-TAD": "G", "KLIZZIE": "G",
            "JEHA": "G", "TSE-GAH": "H", "CHA": "H", "LIN": "H", "TKIN": "I", "YEH-HES": "I", "A-CHI": "I",
            "TKELE-CHO-G": "J", "TKELE-CHO-GI": "J", "AH-YA-TSINNE": "J", "YIL-DOI": "J", "JAD-HO-LONI": "K",
            "BA-AH-NE-DI-TININ": "K", "KLIZZIE-YAZZIE": "K", "DIBEH-YAZZIE": "L", "AH-JAD": "L", "NASH-DOIE-TSO": "L",
            "TSIN-TLITI": "M", "BE-TAS-TNI": "M", "NA-AS-TSO-SI": "M", "TSAH": "N", "A-CHIN": "N", "NESH-CHEE": "N",
            "A-KHA": "O", "TLO-CHIN": "O", "NE-AHS-JAH": "O", "NE-ASH-JAH": "O", "CLA-GI-AIH": "P", "BI-SO-DIH": "P",
            "BI-SODIH": "P", "NE-ZHONI": "P", "CA-YEILTH": "Q", "GAH": "R", "DAH-NES-TSA": "R", "AH-LOSZ": "R",
            "DIBEH": "S", "KLESH": "S", "D-AH": "T", "A-WOH": "T", "THAN-ZIE": "T", "SHI-DA": "U", "NO-DA-IH": "U",
            "A-KEH-DI-GLINI": "V", "GLOE-IH": "W", "AL-NA-AS-DZOH": "X", "AL-AN-AS-DZOH": "X", "TSAH-AS-ZIH": "Y",
            "BESH-DO-TLIZ": "Z", "BESH-DO-GLIZ": "Z", "BE-TKAH": " "}
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Navajo-ABC to Text]
Die Sprache der Navajo-Indianer wurde im zweiten Weltkrieg für
den verschlüßelten Funkverkehr eingesetzt. Vorteile waren, daß
nahezu niemand außer Navajo-Volk die Sprache verstand und es keine
schriftlichen Aufzeichnungen über die Sprache gab. Das Alphabet 
und die Codewörter wurden dabei von den Codesprechern (natürlich
Navajo's) auswendig gelernt.
Die Dekodierfunktion hier übersetzt das Codealphabet (A-Z), bei welchem es
auch so ist, daß unterschiedliche Worte für den selben Buchstaben stehen,
in normalen Text. Leider existieren leicht unterschiedliche Alphabete was
die Wörter bzw. deren Schreibweise angeht im Netz, mit welchen codiert wird,
weshalb ich hier nur die Dekodierung anbiete.
weitere Codewörter und Erklärungen gibt es z.B. hier: 
https://ww2db.com/other.php?other_id=29
http://math.ucsd.edu/~crypto/Projects/RobertoSandoval/NavajoWindtalkers.pdf""" + "\n\n")
    else:
        txt = eingabetext.split()
        atxt = ""
        for wort in txt:
            w = wort.upper()
            if w in nabc:
                atxt = atxt + nabc[w]
        Ausgabe.insert(1.0, atxt + "\n")
        Ausgabe.insert(1.0, "dekodierter Text:", "bu")


def pi_suche():
    hilfetext = """HILFE: [PI Nachkommastellensuche]
Für die eingegebene Zahl/Zahlenreihe X wird versucht die
entsprechende X. Nachkommastelle auszugeben und das erst
Vorkommen der Zahlenreihe X innerhalb der Nachkommastellen
von PI (3.141592653589793238462643...) zu ermitteln.

Da es deutlich schnneller geht mit einer vorgefertigten
Datei zu suchen als die Nachkommastellen zu berechnen 
wird die Datei pi.txt im Unterverzeichnis "data" benötigt.
Diese Datei enthält die Zahl PI mit den ersten 10 Millionen
Nachkommastellen. Wer mehr Stellen braucht, kann sich mit 
dem Tool y-cruncher (http://numberworld.org/y-cruncher/) 
auch eine Datei mit deutlich mehr Nachkommastellen erstellen
und pi.txt damit ersetzen. (Bei 1 Millarde Stellen ist
die Datei dann allerdings schon knapp 1 GB groß und
die Abfrage dauert auch etwas länger)
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            piread = open("./data/pi.txt", "r")
        except FileNotFoundError:
            Ausgabe.insert(1.0, hilfetext + "\n")
        else:
            pistr = ""
            for zeile in piread:
                pistr = pistr + zeile.rstrip()
            piread.close()
            pilen = len(pistr) - 2
            try:
                zahlx = int(eingabetext)
            except ValueError:
                Ausgabe.insert(1.0, "Sorry aber ohne gültige Zahleneingabe funktioniert das nicht!\n", "re")
            else:
                pos = pistr.find(eingabetext)
                if pos == -1:
                    Ausgabe.insert(1.0, "Zahlenreihe in {} Nachkommastellen nicht zu finden.\n\n".format(pilen), "re")
                else:
                    Ausgabe.insert(1.0,
                                   "20 Stellen ab {}. Nachkommstelle: {}...\n\n".format(pos - 1, pistr[pos:pos + 20]))
                    Ausgabe.insert(1.0, 'erstes Vorkommen von Zahlenfolge "{}" ab {}. Nachkommastelle\n'.format(
                        eingabetext.rstrip(), pos - 1))
                if pilen >= zahlx > 0:
                    Ausgabe.insert(1.0, "20 Stellen ab {}. Nachkommstelle: "
                                        "{}...\n\n".format(zahlx, pistr[zahlx + 1:zahlx + 21]))
                    Ausgabe.insert(1.0, "Die {}. Nachkommstelle: lautet {}\n".format(zahlx, pistr[zahlx + 1]))
                else:
                    Ausgabe.insert(1.0, "Die verwendete pi.txt kennt leider nur {} Nachkommstellen.\n\n".format(pilen),
                                   "re")
                Ausgabe.insert(1.0, "PI (Kreiszahl)\n\n", "gr")


def anagramm_suche_de():
    hilfetext = """HILFE: [Anagrammsuche mit Wörterbuch]
Diese Funktion benutzt die deutsche Wörterbuchdatei german.dic
vom Project https://sourceforge.net/projects/germandict um
zu überprüfen ob sich unter Verwendung aller eingegebenen
Buchstaben Wörter bilden lassen, welche im Wörtebuch vorkommen.
Die Datei german.dic muß sich dafür im Unterverzeichnis "data"
befinden.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            wbfile = open("./data/german.dic", "r",
                          encoding="iso-8859-15")  # german.dic von https://sourceforge.net/projects/germandict/
        except FileNotFoundError:
            Ausgabe.insert(1.0, hilfetext + "\n")
        else:
            eingabezaehl = wortzaehl(eingabetext)
            Ausgabe.insert(1.0, "\n")
            for zeile in wbfile:
                zeile = zeile.strip(" \t\n\r")
                if eingabetext.upper() == zeile.upper():
                    continue
                if len(eingabetext) != len(zeile):
                    continue
                if eingabezaehl == wortzaehl(zeile):
                    Ausgabe.insert(1.0, zeile + "\n")
            wbfile.close()
            Ausgabe.insert(1.0, "gefundene Anagramme:\n", "bu")


def wortsuche_de():
    hilfetext = """HILFE: [Wortsuche mit Wörterbuch]
Wer kennt es nicht? Man sucht ein Wort mit einer bestimmten
Anzahl an Buchstaben und weiß aber z.B. nur den Anfangsbuchstaben
und die letzten 3 Buchstaben. Hierbei soll diese Funktion helfen.
Unbekannte Buchstaben werden dabei einfach durch * ersetzt.
Klein-/Großschreibung in der Eingabe wird dabei ignoriert.
Beispiel:
Ge*ca**i**  -> Geocaching
ge*ca**i**  -> Geocaching
T*****dose  -> Tupperdose, Tabaksdose
Da diese Funktion die deutsche Wörterbuchdatei german.dic
vom Project https://sourceforge.net/projects/germandict benutzt
muß sich natürlich die Datei german.dic im Unterverzeichnis "data"
befinden.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            wbfile = open("./data/german.dic", "r", encoding="iso-8859-15")
        except FileNotFoundError:
            Ausgabe.insert(1.0, hilfetext + "\n")
        else:
            Ausgabe.insert(1.0, "\n")
            for zeile in wbfile:
                zeile = zeile.strip(" \t\n\r")
                if len(eingabetext) != len(zeile):
                    continue
                fehler = 0
                for c in range(len(eingabetext)):
                    if eingabetext[c] == "*":
                        continue
                    if eingabetext[c].upper() != zeile[c].upper():
                        fehler += 1
                if fehler == 0:
                    Ausgabe.insert(1.0, zeile + "\n")
            wbfile.close()
            Ausgabe.insert(1.0, "im Wörterbuch gefundene passende Wörter:\n", "bu")


def wortsuche_en():
    hilfetext = """HILFE: [Wortsuche mit Wörterbuch]
Wer kennt es nicht? Man sucht ein Wort mit einer bestimmten
Anzahl an Buchstaben und weiß aber z.B. nur den Anfangsbuchstaben
und die letzten 3 Buchstaben. Hierbei soll diese Funktion helfen.
Unbekannte Buchstaben werden dabei einfach durch * ersetzt.
Klein-/Großschreibung in der Eingabe wird dabei ignoriert.
Beispiel:
Ge*ca**i**  -> geocaching
ge*ca**i**  -> geocaching
say*s       -> say's (Die Wortliste kennt viele Wörter mit Apostroph)
coordinat** -> coordinator, coordinates, coordinated

Da diese Funktion die englische Wörterliste en_US-large.txt
vom Project https://sourceforge.net/projects/wordlist benutzt,
muß sich natürlich die Datei en_US-large.txt im Unterverzeichnis "data"
befinden.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            wbfile = open("./data/en_US-large.txt", "r", encoding="UTF-8")
        except FileNotFoundError:
            Ausgabe.insert(1.0, hilfetext + "\n")
        else:
            Ausgabe.insert(1.0, "\n")
            for zeile in wbfile:
                zeile = zeile.strip(" \t\n\r")
                if len(eingabetext) != len(zeile):
                    continue
                fehler = 0
                for c in range(len(eingabetext)):
                    if eingabetext[c] == "*":
                        continue
                    if eingabetext[c].upper() != zeile[c].upper():
                        fehler += 1
                if fehler == 0:
                    Ausgabe.insert(1.0, zeile + "\n")
            wbfile.close()
            Ausgabe.insert(1.0, "im Wörterbuch gefundene passende Wörter:\n", "bu")


def anagramm_suche_en():
    hilfetext = """HILFE: [Anagrammsuche mit Wörterbuch EN]
Diese Funktion benutzt die englische Wörterliste en_US-large.txt
vom Project https://sourceforge.net/projects/wordlist 
um zu überprüfen ob sich unter Verwendung aller eingegebenen
Buchstaben Wörter bilden lassen, welche im Wörterbuch vorkommen.
Die Datei en_US-large.txt muß sich dafür im Unterverzeichnis
"data" befinden. Dieses Wörterbuch kennt übrigens auch viele
Wörter mit Apostroph wie z.B. "say's".
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            wbfile = open("./data/en_US-large.txt", "r", encoding="UTF-8")
        except FileNotFoundError:
            Ausgabe.insert(1.0, hilfetext + "\n")
        else:
            eingabezaehl = wortzaehl(eingabetext)
            Ausgabe.insert(1.0, "\n")
            for zeile in wbfile:
                zeile = zeile.strip(" \t\n\r")
                if eingabetext.upper() == zeile.upper():
                    continue
                if len(eingabetext) != len(zeile):
                    continue
                if eingabezaehl == wortzaehl(zeile):
                    Ausgabe.insert(1.0, zeile + "\n")
            wbfile.close()
            Ausgabe.insert(1.0, "gefundene Anagramme:\n", "bu")


def remorse_de():
    hilfetext = """HILFE: [RE-Morse DE]
Es gibt ja so Leute, die finden es lustig einen Morsecode
so aufzuschreiben, daß zwar Wort für Wort getrennt wird,
aber ansonsten einfach mal die Leerzeichen weggelassen werden.
Bei genau solchen fiesen Gemeinheiten hilft diese Funktion.
Diese Funktion benutzt die deutsche Wörterbuchdatei german.dic
vom Project https://sourceforge.net/projects/germandict .
Da eine Abfrage relativ lange dauert gibt es die Möglichkeit
aus dem german.dic ein ca. 100 MB großes remorse-de.dic bauen
zu lassen, welches ab der nächsten Abfrage dann genutzt wird
und wodurch dann nur noch ca. 20% der Zeit pro Abfrage benötigt
wird. Um die Erstellung des remorse-de.dic zu starten muß
das Wort GENERATE (Großschreibung beachten!) ins Eingabefeld
eingetragen werden und der Funktionsknopf betätigt werden.
Damit alles funktioniert, muß sich die Datei german.dic
im Unterverzeichnis "data" befinden.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            wbfile = open("./data/morse-de.dic", "r",
                          encoding="iso-8859-15")  # german.dic von https://sourceforge.net/projects/germandict/
        except FileNotFoundError:
            try:
                testfile = open("./data/german.dic", "r")
                testfile.close()
                if eingabetext == "GENERATE":
                    remorse_generate_morsede()
                    Ausgabe.insert(1.0,
                                   "/data/remorse-de wurde erzeugt und \nwird ab dem nächsten Aufruf "
                                   "der Funktion benutzt.\n", "gr")
                else:
                    Ausgabe.insert(1.0, "ins Eingabefeld eingeben und die Funktion starten.\n", "gr")
                    Ausgabe.insert(1.0,
                                   "Um das ca. 100 MB große morse-de.dic einmalig aus\ndem german.dic zu "
                                   "erzeugen bitte das Wort: GENERATE\n", "gr")
                    Ausgabe.insert(1.0, "das dauert zwar ca. 5x so lange, aber geht auch.\n", "gr")
                    Ausgabe.insert(1.0,
                                   "Da das Morsewörter /data/morse-de.dic nicht vorhanden ist,\n"
                                   "wurde /data/german.dic für die Suche benutzt\n", "gr")
                    remorse_germandic()
                return
            except FileNotFoundError:
                Ausgabe.insert(1.0, "Es konnte weder /data/german.dic noch /data/morse-de.dic gefunden werden!\n", "re")
        else:
            Ausgabe.insert(1.0, "\n")
            for zeile in wbfile:
                zeile = zeile.strip(" \t\n\r")
                mline = zeile.split(",")
                if eingabetext == mline[0]:
                    Ausgabe.insert(1.0, mline[1] + "\n")
            wbfile.close()
            Ausgabe.insert(1.0, "der eingegebene Morsecode kann für folgendes stehen:\n", "bu")


def remorse_germandic():
    alphabet = {'A': '.-', 'B': '-...', 'C': '-.-.', 'D': '-..', 'E': '.', 'F': '..-.', 'G': '--.',
                'H': '....', 'I': '..', 'J': '.---', 'K': '-.-', 'L': '.-..', 'M': '--', 'N': '-.',
                'O': '---', 'P': '.--.', 'Q': '--.-', 'R': '.-.', 'S': '...', 'T': '-', 'U': '..-',
                'V': '...-', 'W': '.--', 'X': '-..-', 'Y': '-.--', 'Z': '--..', '1': '.----',
                '2': '..---', '3': '...--', '4': '....-', '5': '.....', '6': '-....', '7': '--...',
                '8': '---..', '9': '----.', '0': '-----', 'Ñ': '--.--', 'É': '..-..', 'È': '.-..-',
                'À': '.--.-', 'Ü': '..--', 'Ö': '---.', 'Ä': '.-.-', '_': '..--.-', '@': '.--.-.',
                '?': '..--..', '=': '-...-', ';': '-.-.-.', ':': '---...', '/': '-..-.',
                '.': '.-.-.-', '-': '-....-', ',': '--..--', '+': '.-.-.', ')': '-.--.-',
                '(': '-.--.', "'": '.----.', 'SS': '...--..'}
    ualphabet = {v: k for k, v in alphabet.items()}
    ualphabet["...--.."] = "ß"
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    wbfile = open("./data/german.dic", "r", encoding="iso-8859-15")
    Ausgabe.insert(1.0, "\n")
    for zeile in wbfile:
        zeile = zeile.strip(" \t\n\r")
        mzeile = ""
        try:
            for char in zeile:
                mzeile += alphabet[char.upper()]
        except KeyError:
            continue
        if eingabetext == mzeile:
            Ausgabe.insert(1.0, zeile + "\n")
    wbfile.close()
    if eingabetext in ualphabet:
        Ausgabe.insert(1.0, ualphabet[eingabetext] + "\n")
    Ausgabe.insert(1.0, "der eingegebene Morsecode kann für folgendes stehen:\n", "bu")


def remorse_generate_morsede():
    alphabet = {'A': '.-', 'B': '-...', 'C': '-.-.', 'D': '-..', 'E': '.', 'F': '..-.', 'G': '--.',
                'H': '....', 'I': '..', 'J': '.---', 'K': '-.-', 'L': '.-..', 'M': '--', 'N': '-.',
                'O': '---', 'P': '.--.', 'Q': '--.-', 'R': '.-.', 'S': '...', 'T': '-', 'U': '..-',
                'V': '...-', 'W': '.--', 'X': '-..-', 'Y': '-.--', 'Z': '--..', '1': '.----',
                '2': '..---', '3': '...--', '4': '....-', '5': '.....', '6': '-....', '7': '--...',
                '8': '---..', '9': '----.', '0': '-----', 'Ñ': '--.--', 'É': '..-..', 'È': '.-..-',
                'À': '.--.-', 'Ü': '..--', 'Ö': '---.', 'Ä': '.-.-', '_': '..--.-', '@': '.--.-.',
                '?': '..--..', '=': '-...-', ';': '-.-.-.', ':': '---...', '/': '-..-.',
                '.': '.-.-.-', '-': '-....-', ',': '--..--', '+': '.-.-.', ')': '-.--.-',
                '(': '-.--.', "'": '.----.', 'SS': '...--..'}
    ofile = open("./data/morse-de.dic", "a", encoding="iso-8859-15")
    ofile.write("-----,0\n.----,1\n..---,2\n...--,3\n....-,4\n.....,5\n-....,6\n--...,7\n---..,8\n----.,9\n")
    ofile.write(".-,A\n-...,B\n-.-.,C\n-..,D\n.,E\n..-.,F\n--.,G\n....,H\n..,I\n.---,J\n-.-,K\n.-..,L\n--,M\n")
    ofile.write("-.,N\n---,O\n.--.,P\n--.-,Q\n.-.,R\n...,S\n-,T\n..-,U\n...-,V\n.--,W\n-..-,X\n-.--,Y\n--..,Z\n")
    ofile.write("--.--,Ñ\n..-..,É\n.-..-,È\n.--.-,À\n..--,Ü\n---.,Ö\n.-.-,Ä\n..--.-,_\n.--.-.,@\n..--..,?\n-...-,=\n")
    ofile.write("-.-.-.,;\n---...,:\n-..-.,/\n.-.-.-,.\n-....-,-\n.-.-.,+\n-.--.-,)\n-.--.,(\n.----.,'\n...--..,ß\n")
    file = open("./data/german.dic", "r", encoding="iso-8859-15")
    for zeile in file:
        omsg = ""
        zeile = zeile.rstrip()
        try:
            for char in zeile:
                omsg = omsg + alphabet[char.upper()]
        except TypeError:
            continue
        else:
            ofile.write(omsg + "," + zeile + "\n")
    file.close()
    ofile.close()


def remorse_en():
    hilfetext = """HILFE: [RE-Morse EN]
Es gibt ja so Leute, die finden es lustig einen
Morsecode so aufzuschreiben, daß zwar Wort für
Wort getrennt wird, aber ansonsten einfach mal
die Leerzeichen weggelassen werden. Bei genau
solchen fiesen Gemeinheiten hilft diese Funktion.
Mit Hilfe der englischen Wörterliste en_US-large.txt
vom Project https://sourceforge.net/projects/wordlist 
wird überprüft, für welches Wort der eingegebene Morsecode
stehen könnte. Die Datei en_US-large.txt muß sich dafür
im Unterverzeichnis "data" befinden.
"""
    alphabet = {'A': '.-', 'B': '-...', 'C': '-.-.', 'D': '-..', 'E': '.', 'F': '..-.', 'G': '--.',
                'H': '....', 'I': '..', 'J': '.---', 'K': '-.-', 'L': '.-..', 'M': '--', 'N': '-.',
                'O': '---', 'P': '.--.', 'Q': '--.-', 'R': '.-.', 'S': '...', 'T': '-', 'U': '..-',
                'V': '...-', 'W': '.--', 'X': '-..-', 'Y': '-.--', 'Z': '--..', '1': '.----',
                '2': '..---', '3': '...--', '4': '....-', '5': '.....', '6': '-....', '7': '--...',
                '8': '---..', '9': '----.', '0': '-----', 'Ñ': '--.--', 'É': '..-..', 'È': '.-..-',
                'À': '.--.-', 'Ü': '..--', 'Ö': '---.', 'Ä': '.-.-', '_': '..--.-', '@': '.--.-.',
                '?': '..--..', '=': '-...-', ';': '-.-.-.', ':': '---...', '/': '-..-.',
                '.': '.-.-.-', '-': '-....-', ',': '--..--', '+': '.-.-.', ')': '-.--.-',
                '(': '-.--.', "'": '.----.', 'SS': '...--..'}
    ualphabet = {v: k for k, v in alphabet.items()}
    ualphabet["...--.."] = "ß"
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            wbfile = open("./data/en_US-large.txt", "r", encoding="UTF-8")
        except FileNotFoundError:
            Ausgabe.insert(1.0, hilfetext + "\n")
        else:
            Ausgabe.insert(1.0, "\n")
            for zeile in wbfile:
                zeile = zeile.strip(" \t\n\r")
                mzeile = ""
                try:
                    for char in zeile:
                        mzeile += alphabet[char.upper()]
                except KeyError:
                    continue
                if eingabetext == mzeile:
                    Ausgabe.insert(1.0, zeile + "\n")
            wbfile.close()
            if eingabetext in ualphabet:
                Ausgabe.insert(1.0, ualphabet[eingabetext] + "\n")
            Ausgabe.insert(1.0, "der eingegebene Morsecode kann für folgendes stehen:\n", "bu")


def t9_de():
    hilfetext = """HILFE: [T9-DE]
Diese Funktion benutzt die deutsche Wörterbuchdatei german.dic
vom Project https://sourceforge.net/projects/germandict .
ermittelt diese Funktion alle im Wörterbuch enthaltenen
Wörter die zu der eingegebenen T9-kodierten Ziffernfolge
passen und gibt diese aus.

Bsp. 56673462836 liefert das Wort Koordinaten

Da eine Abfrage relativ lange dauert gibt es die Möglichkeit
aus dem german.dic ein ca. 60 MB großes t9-de.dic bauen
zu lassen, welches ab der nächsten Abfrage dann genutzt wird
und wodurch dann nur noch ca. 15% der Zeit pro Abfrage benötigt
wird. Um die Erstellung des t9-de.dic zu starten muß
das Wort GENERATE (Großschreibung beachten!) ins Eingabefeld
eingetragen werden und der Funktionsknopf betätigt werden.
Damit alles funktioniert, muß sich die Datei german.dic
im Unterverzeichnis "data" befinden.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            wbfile = open("./data/t9-de.dic", "r", encoding="iso-8859-15")
        except FileNotFoundError:
            try:
                testfile = open("./data/german.dic", "r")
                testfile.close()
                if eingabetext == "GENERATE":
                    t9_generate_t9de()
                    Ausgabe.insert(1.0,
                                   "/data/t9-de.dic wurde erzeugt und \n"
                                   "wird ab dem nächsten Aufruf der Funktion benutzt.\n", "gr")
                else:
                    Ausgabe.insert(1.0, "ins Eingabefeld eingeben und die Funktion starten.\n", "gr")
                    Ausgabe.insert(1.0,
                                   "Um das ca. 60 MB große t9-de.dic einmalig aus\n"
                                   "dem german.dic zu erzeugen bitte das Wort: GENERATE\n", "gr")
                    Ausgabe.insert(1.0, "das dauert zwar ca. 7x so lange, aber geht auch.\n", "gr")
                    Ausgabe.insert(1.0,
                                   "Da das T9-Wörterbuch /data/t9-de.dic nicht vorhanden ist,\n"
                                   "wurde /data/german.dic für die Suche benutzt\n", "gr")
                    t9_germandic()
                return
            except FileNotFoundError:
                Ausgabe.insert(1.0, "Es konnte weder /data/german.dic noch /data/t9-de.dic gefunden werden!\n", "re")
        else:
            Ausgabe.insert(1.0, "\n")
            for zeile in wbfile:
                zeile = zeile.strip(" \t\n\r")
                mline = zeile.split(",")
                if eingabetext == mline[0]:
                    Ausgabe.insert(1.0, mline[1] + "\n")
            wbfile.close()
            Ausgabe.insert(1.0, "der eingegebene T9-Code kann für folgendes stehen:\n", "bu")


def t9_germandic():
    alphabet = {'A': '2', 'B': '2', 'C': '2', 'D': '3', 'E': '3', 'F': '3', 'G': '4',
                'H': '4', 'I': '4', 'J': '5', 'K': '5', 'L': '5', 'M': '6', 'N': '6',
                'O': '6', 'P': '7', 'Q': '7', 'R': '7', 'S': '7', 'T': '8', 'U': '8',
                'V': '8', 'W': '9', 'X': '9', 'Y': '9', 'Z': '9', '1': '1', '2': '2',
                '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9',
                '0': '0', 'Ñ': '6', 'É': '3', 'È': '3', 'À': '2', 'Ü': '8', 'Ö': '6',
                'Ä': '2', '@': '1', '?': '1', '=': '0', ':': '1', '/': '1', '.': '1',
                '-': '1', ',': '1', '+': '0', ')': '1', '(': '1', 'SS': '7'}
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    wbfile = open("./data/german.dic", "r", encoding="iso-8859-15")
    Ausgabe.insert(1.0, "\n")
    for zeile in wbfile:
        zeile = zeile.strip(" \t\n\r")
        mzeile = ""
        try:
            for char in zeile:
                mzeile += alphabet[char.upper()]
        except KeyError:
            continue
        if eingabetext == mzeile:
            Ausgabe.insert(1.0, zeile + "\n")
    wbfile.close()
    Ausgabe.insert(1.0, "der eingegebene T9-Code kann für folgendes stehen:\n", "bu")


def t9_generate_t9de():
    alphabet = {'A': '2', 'B': '2', 'C': '2', 'D': '3', 'E': '3', 'F': '3', 'G': '4',
                'H': '4', 'I': '4', 'J': '5', 'K': '5', 'L': '5', 'M': '6', 'N': '6',
                'O': '6', 'P': '7', 'Q': '7', 'R': '7', 'S': '7', 'T': '8', 'U': '8',
                'V': '8', 'W': '9', 'X': '9', 'Y': '9', 'Z': '9', '1': '1', '2': '2',
                '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9',
                '0': '0', 'Ñ': '6', 'É': '3', 'È': '3', 'À': '2', 'Ü': '8', 'Ö': '6',
                'Ä': '2', '@': '1', '?': '1', '=': '0', ':': '1', '/': '1', '.': '1',
                '-': '1', ',': '1', '+': '0', ')': '1', '(': '1', 'SS': '7'}
    ofile = open("./data/t9-de.dic", "a", encoding="iso-8859-15")
    file = open("./data/german.dic", "r", encoding="iso-8859-15")
    for zeile in file:
        omsg = ""
        zeile = zeile.rstrip()
        try:
            for char in zeile:
                omsg = omsg + alphabet[char.upper()]
        except KeyError:
            continue
        else:
            ofile.write(omsg + "," + zeile + "\n")
    file.close()
    ofile.close()


def t9_en():
    hilfetext = """HILFE: [T9 EN]
Mit Hilfe der englischen Wörterliste en_US-large.txt
vom Project https://sourceforge.net/projects/wordlist 
ermittelt diese Funktion alle im Wörterbuch enthaltenen
Wörter die zu der eingegebenen T9-kodierten Ziffernfolge
passen und gibt diese aus.

Bsp. 26673462837 liefert das Wort coordinates

Die Datei en_US-large.txt muß sich dafür
im Unterverzeichnis "data" befinden.
"""
    alphabet = {'A': '2', 'B': '2', 'C': '2', 'D': '3', 'E': '3', 'F': '3', 'G': '4',
                'H': '4', 'I': '4', 'J': '5', 'K': '5', 'L': '5', 'M': '6', 'N': '6',
                'O': '6', 'P': '7', 'Q': '7', 'R': '7', 'S': '7', 'T': '8', 'U': '8',
                'V': '8', 'W': '9', 'X': '9', 'Y': '9', 'Z': '9', '1': '1', '2': '2',
                '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9',
                '0': '0', 'Ñ': '6', 'É': '3', 'È': '3', 'À': '2', 'Ü': '8', 'Ö': '6',
                'Ä': '2', '@': '1', '?': '1', '=': '0', ':': '1', '/': '1', '.': '1',
                '-': '1', ',': '1', '+': '0', ')': '1', '(': '1', 'SS': '7'}
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            wbfile = open("./data/en_US-large.txt", "r", encoding="UTF-8")
        except FileNotFoundError:
            Ausgabe.insert(1.0, hilfetext + "\n")
        else:
            Ausgabe.insert(1.0, "\n")
            for zeile in wbfile:
                zeile = zeile.strip(" \t\n\r")
                mzeile = ""
                try:
                    for char in zeile:
                        mzeile += alphabet[char.upper()]
                except KeyError:
                    continue
                if eingabetext == mzeile:
                    Ausgabe.insert(1.0, zeile + "\n")
            wbfile.close()
            Ausgabe.insert(1.0, "der eingegebene T9-Code kann für folgendes stehen:\n", "bu")


def vigenere():
    hilfetext = """HILFE: [Vigenere-Chiffre]
Die Eingabe eines Schlüsselwortes ist hier erforderlich!!!
Die Vigenere-Chiffre baut auf dem Prinzip der Cesar-Chiffre
auf, wobei hier die Verschiebung jedes einzelnen Buchstaben
durch die Buchstabenwerte eines Schlüsselwortes definiert 
werden. Da der zu verschlüsselnde Text im allgemeinen
länger als das Schlüsselwort ist, wird das Schlüsselwort immer
wieder wiederholt. Ist der Schlüssel mindestens genauso lang wie
der Klartext entspricht dies dann dem One-Time-Pad-Chiffre.
Der eingegebene Text wird hier mit dem eingegebenen Schlüsselwort
kodiert und dekodiert ausgegeben und zwar sowohl in der
Variante, daß Sonderzeichen Schlüsselbuchstaben verbrauchen
als auch nicht.
"""
    bw = {'A': 1, 'B': 2, 'C': 3, 'D': 4, 'E': 5, 'F': 6, 'G': 7, 'H': 8, 'I': 9, 'J': 10, 'K': 11, 'L': 12, 'M': 13,
          'N': 14,
          'O': 15, 'P': 16, 'Q': 17, 'R': 18, 'S': 19, 'T': 20, 'U': 21, 'V': 22, 'W': 23, 'X': 24, 'Y': 25, 'Z': 26}
    ubw = {v: k for k, v in bw.items()}
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if text == "" or pw == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        for b in pw:
            if b.upper() not in bw:
                Ausgabe.insert(1.0, "Das Passwort darf nur die Buchstaben A-Z / a-z enthalten!\n", "re")
                return
        pwl = len(pw)
        encoded_text = ""
        encoded_text_s = ""  # wenn Leer und Sonderzeichen Schlüsselbuchstaben verbrauchen
        auslz = 0  # auslasszähler zählt zeichen die im text nicht codiert wurden
        for i in range(len(text)):
            if text[i].upper() not in bw:
                encoded_text += text[i]
                auslz += 1
                encoded_text_s += text[i]
            else:
                b1 = bw[text[i].upper()]
                b2 = bw[pw[(i - auslz) % pwl].upper()]
                b2s = bw[pw[i % pwl].upper()]
                ba = (b1 + b2 - 1) % 26
                bas = (b1 + b2s - 1) % 26
                if ba == 0:
                    ba = 26
                if bas == 0:
                    bas = 26
                if text[i] == text[i].upper():
                    encoded_text += ubw[ba]
                    encoded_text_s += ubw[bas]
                else:
                    encoded_text += ubw[ba].lower()
                    encoded_text_s += ubw[bas].lower()
        decoded_text = ""
        decoded_text_s = ""
        auslz = 0  # auslasszähler zählt zeichen die im text nicht codiert wurden
        for i in range(len(text)):
            if text[i].upper() not in bw:
                decoded_text += text[i]
                auslz += 1
                decoded_text_s += text[i]
            else:
                b1 = bw[text[i].upper()]
                b2 = bw[pw[(i - auslz) % pwl].upper()]
                b2s = bw[pw[i % pwl].upper()]
                ba = (b1 - b2 + 1) % 26
                bas = (b1 - b2s + 1) % 26
                if ba == 0:
                    ba = 26
                if bas == 0:
                    bas = 26
                if text[i] == text[i].upper():
                    decoded_text += ubw[ba]
                    decoded_text_s += ubw[bas]
                else:
                    decoded_text += ubw[ba].lower()
                    decoded_text_s += ubw[bas].lower()
        Ausgabe.insert(1.0, encoded_text_s + "\n")
        Ausgabe.insert(1.0, "Kodiert - Sonderzeichen verbrauchen Schlüsselbuchstaben:\n", "bu")
        Ausgabe.insert(1.0, decoded_text_s + "\n")
        Ausgabe.insert(1.0, "Dekodiert - Sonderzeichen verbrauchen Schlüsselbuchstaben:\n", "bu")
        Ausgabe.insert(1.0, encoded_text + "\n")
        Ausgabe.insert(1.0, "Kodiert - normal:\n", "bu")
        Ausgabe.insert(1.0, decoded_text + "\n")
        Ausgabe.insert(1.0, "Dekodiert - normal:\n", "bu")


def wolseley():
    hilfetext = """HILFE: [Wolseley-Chiffre]
Die Eingabe eines Schlüsselwortes ist hier erforderlich!!!
Die Woseley-Chiffre arbeitet mit einem Schlüsselwort über 
welches dann ein Codequadrat/Codealphabet gebildet wird 
mit welchem dann sowohl kodiert als auch dekodiert wird.
Angefangen wird dabei mit dem jeweils ersten Vorkommen
eines Buchstaben im Schlüsselwort und danach folgen die
restlichen Buchstaben des Alphabets die nicht im 
Schlüsselwort vorkommen. Da hier nur 25 Zeichen zur
Verfügung stehen wird das J mit dem I zusammengefasst
und als I behandelt und dargestellt. Sonstige Zeichen
die nicht im Codealphabet vorhanden sind werden unverändert
ausgegeben.
Codequadrat mit Schlüsselwort: Teebaum
  1 2 3 4 5 
1 T E B A U
2 M C D F G
3 H I K L N
4 O P Q R S
5 V W X Y Z
Bei der Chiffrierung/Dechiffrierung wird im Text nun der
erste Buchstabe mit dem  letzten getauscht, der 2. mit dem
Vorletzten, usw.
also aus T wird Z und umgekehrt,E<->Y, B<->X, A<->W  usw..
nur ein K bleibt ein K
"""
    abc = "ABCDEFGHIKLMNOPQRSTUVWXYZ"  # j wird als i chiffriert
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if text == "" or pw == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        for b in pw:
            if b.upper() not in "ABCDEFGHIJKLMNOPQRSTUVWXYZ":
                Ausgabe.insert(1.0, "Das Passwort darf nur die Buchstaben A-Z / a-z enthalten!\n", "re")
                return
        text = text.upper()
        pw = pw.upper()
        if "J" in text:
            text = text.replace("J", "I")
        if "J" in pw:
            pw = pw.replace("J", "I")
        calpha = ""
        for b in pw:
            if b not in calpha:
                calpha += b
        for b in abc:
            if b not in calpha:
                calpha += b
        cabc = {calpha[12]: calpha[12]}
        c1 = calpha[:12]
        c2 = calpha[13:]
        c2 = c2[::-1]
        for i in range(12):
            cabc[c1[i]] = c2[i]
        ucabc = {v: k for k, v in cabc.items()}
        cabc.update(ucabc)
        atxt = ""
        for b in text:
            if b in cabc:
                atxt += cabc[b]
            else:
                atxt += b
        Ausgabe.insert(1.0, atxt + "\n")


def atbash():
    hilfetext = """HILFE: [Atbash-Chiffre]
Atbash ist eine einfache Ersetzungschiffre die für
das hebräische Alphabet entwickelt wurde, welche
später auf das lateinische Alphabet übertragen wurde.
Dabei wird dem normalen Alphabet ein rückwärtsgelesenes
Alphabet gegenüber gestellt. A wird zu Z, B zu Y usw.
Kodierung und Dekodierung erfolgt über die selbe Funktion.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        abc = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        uabc = abc[::-1]
        cabc = {}
        for i in range(26):
            cabc[abc[i]] = uabc[i]
        atxt = ""
        for b in text:
            if b.upper() in cabc:
                if b == b.upper():
                    atxt += cabc[b]
                else:
                    atxt += cabc[b.upper()].lower()
            else:
                atxt += b
        Ausgabe.insert(1.0, atxt + "\n")


def monoalphasubstitution():
    hilfetext = """HILFE: [Monoalphabetische Substitutions-Chiffre]
Bei der monoalphabetischen Substitution wird jedem Buchstaben des
Alphabet dem Buchstaben eines Schlüsselalphabets zugeordnet:
Bsp. Klartextalphabet: ABCDEFGHIJKLMNOPQRSTUVWXYZ
    Schlüsselalphabet: DSBJFALKNVPOQXYWCEGHIMRTUZ
Spezialformen dieser Chiffre sind Atbash, Cesar, Rot13
Die Funktion hier arbeitet so, daß entweder ein komplettes
Schlüsselalphabet oder ein Schlüsselwort verwendet werden kann.
Wird ein Schlüsselwort genutzt wird der Rest des Schlüsselalphabet
automatisch aufgefüllt.
Aus dem Schlüsselwort GutenMorgenLiebeSonne wird dabei dann das
Schlüsselalphabet: GUTENMORLIBSACDFHJKPQVWXYZ
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if text == "" or pw == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        abc = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        for b in pw:
            if b.upper() not in abc:
                Ausgabe.insert(1.0, "Das Passwort darf nur die Buchstaben A-Z / a-z enthalten!\n", "re")
                return
        cabc = ""
        for b in pw.upper() + abc:
            if b not in cabc:
                cabc += b
        cab = {}
        for i in range(26):
            cab[abc[i]] = cabc[i]
        ucab = {v: k for k, v in cab.items()}
        encoded_txt = ""
        for b in text:
            if b.upper() in cab:
                if b == b.upper():
                    encoded_txt += cab[b]
                else:
                    encoded_txt += cab[b.upper()].lower()
            else:
                encoded_txt += b
        decoded_txt = ""
        for b in text:
            if b.upper() in ucab:
                if b == b.upper():
                    decoded_txt += ucab[b]
                else:
                    decoded_txt += ucab[b.upper()].lower()
            else:
                decoded_txt += b
        if len(pw) < len(abc):
            Ausgabe.insert(1.0, "Schlüsselalphabet wurde wie folgt aufgefüllt: " + cabc + "\n", "gr")
        Ausgabe.insert(1.0, encoded_txt + "\n")
        Ausgabe.insert(1.0, "Kodiert:\n", "bu")
        Ausgabe.insert(1.0, decoded_txt + "\n")
        Ausgabe.insert(1.0, "Dekodiert:\n", "bu")


def autokey():
    hilfetext = """HILFE: [Autokey-Chiffre]
Die Autokey-Chiffre arbeitet nach dem selben
Prinzip wie Vignere-Chiffre mit dem Unterschied,
daß hier am Ende des Schlüsselwortes nicht wieder
und wieder das Schlüsselwort angehängt wird,
sondern der Klartext an das Schlüsselwort
angehangen wird. 
Der eingegebene Text wird hier mit dem eingegebenen
Schlüsselwort kodiert und dekodiert ausgegeben.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if text == "" or pw == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        bw = {'A': 1, 'B': 2, 'C': 3, 'D': 4, 'E': 5, 'F': 6, 'G': 7, 'H': 8, 'I': 9, 'J': 10, 'K': 11, 'L': 12,
              'M': 13, 'N': 14,
              'O': 15, 'P': 16, 'Q': 17, 'R': 18, 'S': 19, 'T': 20, 'U': 21, 'V': 22, 'W': 23, 'X': 24, 'Y': 25,
              'Z': 26}
        ubw = {v: k for k, v in bw.items()}
        p_we = ""
        p_wd = ""
        for b in pw:
            if b.upper() not in bw:
                Ausgabe.insert(1.0, "Das Passwort darf nur die Buchstaben A-Z / a-z enthalten!\n", "re")
                return
            else:
                p_we += b.upper()  # Sonderzeichen aus PW entfernen und
                p_wd += b.upper()
        if len(p_we) < len(text):
            for b in text:
                if b.upper() in bw:
                    p_we += b.upper()
        encoded_text = ""
        auslz = 0  # auslasszähler zählt zeichen die im text nicht codiert wurden
        for i in range(len(text)):
            if text[i].upper() not in bw:
                encoded_text += text[i]
                auslz += 1
            else:
                b1 = bw[text[i].upper()]
                b2 = bw[p_we[(i - auslz)]]
                ba = (b1 + b2 - 1) % 26
                if ba == 0:
                    ba = 26
                if text[i] == text[i].upper():
                    encoded_text += ubw[ba]
                else:
                    encoded_text += ubw[ba].lower()
        decoded_text = ""
        auslz = 0
        for i in range(len(text)):
            if text[i].upper() not in bw:
                decoded_text += text[i]
                auslz += 1
            else:
                b1 = bw[text[i].upper()]
                b2 = bw[p_wd[(i - auslz)].upper()]
                ba = (b1 - b2 + 1) % 26
                if ba == 0:
                    ba = 26
                p_wd += ubw[ba]
                if text[i] == text[i].upper():
                    decoded_text += ubw[ba]
                else:
                    decoded_text += ubw[ba].lower()
        Ausgabe.insert(1.0, encoded_text + "\n")
        Ausgabe.insert(1.0, "Kodiert:\n", "bu")
        Ausgabe.insert(1.0, decoded_text + "\n")
        Ausgabe.insert(1.0, "Dekodiert:\n", "bu")


def polybios_encode():
    hilfetext = """HILFE: [Polybios-Chiffre kodieren]
Die 5x5 Polybios-Chiffre kodiert Buchstaben zu zweistelligen
Zahlen dazu wird das Schlüsselalphabet in ein 5x5-Quadrat
eingetragen. Die Buchstaben werden dann sozusagen zu ihren
entsprechenden "Koordinaten" kodiert. Im unten gezeigten
Quadrat wird so aus A 11, aus B 12, aus Q 41, usw.  
Da in ein 5x5 Quadrat nur 25 Buchstaben passen wird
typischer Weise J und I zusammengefasst,
(alternativ auch U und V), sollen auch Ziffern kodiert
werden wird mit einem 6x6-Quadrat gearbeitet, bei welchem
dann für das komplette Alphabet und die Ziffern 0-9 Platz ist.
  1 2 3 4 5
1 A B C D E
2 F G H I K
3 L M N O P
4 Q R S T U
5 V W X Y Z
Kommt für die Chiffre ein Passwort zum Einsatz wird das 
Code-Quadrat so abgeändert wie es in der Hilfe zur
Woseley-Chiffre beschrieben ist.
Die Funktion ist so gestaltet, daß alle nicht im jeweiligen
Codealphabet vorhandenen Zeichen herausgefiltert werden.
Zur Information wird für jede Polybios-Variante auch noch
einmal der verwendete Klartext und das verwendete Passwort
ausgegeben wird.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        qz5 = [11, 12, 13, 14, 15, 21, 22, 23, 24, 25, 31, 32, 33, 34, 35, 41, 42, 43, 44, 45, 51, 52, 53, 54, 55]
        alpha5ij = "ABCDEFGHIKLMNOPQRSTUVWXYZ"  # j wird durch i ersetzt
        alpha5uv = "ABCDEFGHIJKLMNOPQRSTUWXYZ"  # v wird durch u ersetzt
        qz6 = [11, 12, 13, 14, 15, 16, 21, 22, 23, 24, 25, 26, 31, 32, 33, 34, 35, 36, 41, 42, 43, 44, 45, 46, 51, 52,
               53, 54, 55, 56, 61, 62, 63, 64, 65, 66]
        alpha6 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
        text = text.upper()
        textij = text.replace("J", "I")
        textuv = text.replace("V", "U")
        pw = pw.upper()
        p_wi = pw.replace("J", "I")
        p_wu = pw.replace("V", "U")
        passw5ij = ""
        for i in p_wi:
            if i in alpha5ij:
                passw5ij += i
        passw5uv = ""
        for i in p_wu:
            if i in alpha5uv:
                passw5uv += i
        passw6 = ""
        for i in p_wi:
            if i in alpha6:
                passw6 += i
        text5ij = ""
        for i in textij:
            if i in alpha5ij or i == " ":
                text5ij += i
        text5uv = ""
        for i in textuv:
            if i in alpha5uv or i == " ":
                text5uv += i
        text6 = ""
        for i in text:
            if i in alpha6 or i == " ":
                text6 += i
        pw5ij = ""
        for b in p_wi + alpha5ij:
            if b in alpha5ij and b not in pw5ij:
                pw5ij += b
        pw5uv = ""
        for b in p_wu + alpha5uv:
            if b in alpha5uv and b not in pw5uv:
                pw5uv += b
        pw6 = ""
        for b in pw + alpha6:
            if b in alpha6 and b not in pw6:
                pw6 += b
        wb5ij = {" ": " "}
        for i in range(25):
            wb5ij[pw5ij[i]] = str(qz5[i])
        wb5uv = {" ": " "}
        for i in range(25):
            wb5uv[pw5uv[i]] = str(qz5[i])
        wb6 = {" ": " "}
        for i in range(36):
            wb6[pw6[i]] = str(qz6[i])
        ctext5ij = ""
        for b in text5ij:
            ctext5ij += wb5ij[b]
        ctext5uv = ""
        for b in text5uv:
            ctext5uv += wb5uv[b]
        ctext6 = ""
        for b in text6:
            ctext6 += wb6[b]
        Ausgabe.insert(1.0, ctext6 + "\n")
        Ausgabe.insert(1.0, "Passwort: " + passw6 + "\n", "gr")
        Ausgabe.insert(1.0, "Klartext: " + text6 + "\n", "gr")
        Ausgabe.insert(1.0, "Polybios 6x6\n", "bu")
        Ausgabe.insert(1.0, ctext5uv + "\n\n")
        Ausgabe.insert(1.0, "Passwort: " + passw5uv + "\n", "gr")
        Ausgabe.insert(1.0, "Klartext: " + text5uv + "\n", "gr")
        Ausgabe.insert(1.0, "Polybios 5x5 (v=u)\n", "bu")
        Ausgabe.insert(1.0, ctext5ij + "\n\n")
        Ausgabe.insert(1.0, "Passwort: " + passw5ij + "\n", "gr")
        Ausgabe.insert(1.0, "Klartext: " + text5ij + "\n", "gr")
        Ausgabe.insert(1.0, "Polybios 5x5 (j=i)\n", "bu")


def polybios_decode():
    hilfetext = """HILFE: [Polybios-Chiffre dekodieren]
Die 5x5 Polybios-Chiffre kodiert Buchstaben zu zweistelligen
Zahlen dazu wird das Schlüsselalphabet in ein 5x5-Quadrat
eingetragen. Die Buchstaben werden dann sozusagen zu ihren
entsprechenden "Koordinaten" kodiert. Im unten gezeigten
Quadrat wird so aus A 11, aus B 12, aus Q 41, usw.  
Da in ein 5x5 Quadrat nur 25 Buchstaben passen wird
typischer Weise J und I zusammengefasst,
(alternativ auch U und V), sollen auch Ziffern kodiert
werden wird mit einem 6x6-Quadrat gearbeitet, bei welchem
dann für das komplette Alphabet und die Ziffern 0-9 Platz ist.
  1 2 3 4 5
1 A B C D E
2 F G H I K
3 L M N O P
4 Q R S T U
5 V W X Y Z
Kommt für die Chiffre ein Passwort zum Einsatz wird das 
Code-Quadrat so abgeändert wie es in der Hilfe zur
Woseley-Chiffre beschrieben ist.
Die Funktion ist so gestaltet, daß alle nicht im jeweiligen
Codealphabet vorhandenen Zeichen herausgefiltert werden.
Zur Information wird für jede Polybios-Variante auch noch
einmal das verwendete Passwort ausgegeben wird.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        qz5 = [11, 12, 13, 14, 15, 21, 22, 23, 24, 25, 31, 32, 33, 34, 35, 41, 42, 43, 44, 45, 51, 52, 53, 54, 55]
        alpha5ij = "ABCDEFGHIKLMNOPQRSTUVWXYZ"  # j wird durch i ersetzt
        alpha5uv = "ABCDEFGHIJKLMNOPQRSTUWXYZ"  # v wird durch u ersetzt
        qz6 = [11, 12, 13, 14, 15, 16, 21, 22, 23, 24, 25, 26, 31, 32, 33, 34, 35, 36, 41, 42, 43, 44, 45, 46, 51, 52,
               53, 54, 55, 56, 61, 62, 63, 64, 65, 66]
        alpha6 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
        pw = pw.upper()
        p_wi = pw.replace("J", "I")
        p_wu = pw.replace("V", "U")
        passw5ij = ""
        for i in p_wi:
            if i in alpha5ij:
                passw5ij += i
        passw5uv = ""
        for i in p_wu:
            if i in alpha5uv:
                passw5uv += i
        passw6 = ""
        for i in p_wi:
            if i in alpha6:
                passw6 += i
        pw5ij = ""
        for b in p_wi + alpha5ij:
            if b in alpha5ij and b not in pw5ij:
                pw5ij += b
        pw5uv = ""
        for b in p_wu + alpha5uv:
            if b in alpha5uv and b not in pw5uv:
                pw5uv += b
        pw6 = ""
        for b in pw + alpha6:
            if b in alpha6 and b not in pw6:
                pw6 += b
        wb5ij = {" ": " "}
        for i in range(25):
            wb5ij[str(qz5[i])] = pw5ij[i]
        wb5uv = {" ": " "}
        for i in range(25):
            wb5uv[str(qz5[i])] = pw5uv[i]
        wb6 = {" ": " "}
        for i in range(36):
            wb6[str(qz6[i])] = pw6[i]
        text = text.split()
        ctext5ij = ""
        ctext5uv = ""
        ctext6 = ""
        for wort in text:
            for i in range(0, len(wort), 2):
                cc = wort[i:i + 2]
                if cc in wb5ij:
                    ctext5ij += wb5ij[cc]
                if cc in wb5uv:
                    ctext5uv += wb5uv[cc]
                if cc in wb6:
                    ctext6 += wb6[cc]
            ctext5ij += " "
            ctext5uv += " "
            ctext6 += " "
        Ausgabe.insert(1.0, ctext6 + "\n")
        Ausgabe.insert(1.0, "Passwort: " + passw6 + "\n", "gr")
        Ausgabe.insert(1.0, "Polybios 6x6\n", "bu")
        Ausgabe.insert(1.0, ctext5uv + "\n\n")
        Ausgabe.insert(1.0, "Passwort: " + passw5uv + "\n", "gr")
        Ausgabe.insert(1.0, "Polybios 5x5 (v=u)\n", "bu")
        Ausgabe.insert(1.0, ctext5ij + "\n\n")
        Ausgabe.insert(1.0, "Passwort: " + passw5ij + "\n", "gr")
        Ausgabe.insert(1.0, "Polybios 5x5 (j=i)\n", "bu")


def klopfcode_encode():
    hilfetext = """HILFE: [Klopfcode kodieren]
Der Klopfcode ist im Prinzip eine Polybios Chiffre 
mit einem festen Schlüsselquadrat bei welchem nicht
I und J sondern C und K zusammengefasst werden.
siehe hier:
  1 2 3 4 5
1 A B C D E
2 F G H I J
3 L M N O P
4 Q R S T U
5 V W X Y Z
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        qz5 = [11, 12, 13, 14, 15, 21, 22, 23, 24, 25, 31, 32, 33, 34, 35, 41, 42, 43, 44, 45, 51, 52, 53, 54, 55]
        alpha = "ABCDEFGHIJLMNOPQRSTUVWXYZ"  # k wird durch c ersetzt
        text = text.upper()
        text = text.replace("K", "C")
        text5 = ""
        for i in text:
            if i in alpha or i == " ":
                text5 += i
        wb5 = {" ": " "}
        for i in range(25):
            wb5[alpha[i]] = str(qz5[i])
        ctext = ""
        for b in text5:
            ctext += wb5[b]
        Ausgabe.insert(1.0, ctext + "\n")
        Ausgabe.insert(1.0, "Klartext: " + text5 + "\n", "gr")


def klopfcode_decode():
    hilfetext = """HILFE: [Klopfcode dekodieren]
Der Klopfcode ist im Prinzip eine Polybios Chiffre 
mit einem festen Schlüsselquadrat bei welchem nicht
I und J sondern C und K zusammengefasst werden.
siehe hier:
  1 2 3 4 5
1 A B C D E
2 F G H I J
3 L M N O P
4 Q R S T U
5 V W X Y Z
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        qz5 = [11, 12, 14, 15, 21, 22, 23, 24, 25, 31, 32, 33, 34, 35, 41, 42, 43, 44, 45, 51, 52, 53, 54, 55]
        alpha = "ABDEFGHIJLMNOPQRSTUVWXYZ"  # k wird durch c ersetzt
        wb = {" ": " ", "13": "[C/K]"}
        for i in range(24):
            wb[str(qz5[i])] = alpha[i]
        text = text.split()
        ctext = ""
        for wort in text:
            for i in range(0, len(wort), 2):
                cc = wort[i:i + 2]
                if cc in wb:
                    ctext += wb[cc]
            ctext += " "
        Ausgabe.insert(1.0, ctext + "\n")
        Ausgabe.insert(1.0, "Klopfcode dekodiert:\n", "bu")


def maptiles_kachelkoordinaten():
    hilfetext = """HILFE: [Maptiles / Kachelkoordinaten]
Bei vielen Online-Kartendiensten wie Openstreetmap oder Google-Maps erfolgt die
Kartendarstellung über vorberechnete "Kachel"-Grafikdateien, welche ein 
Adressierungssystem benötigen damit je nach Koordinate und Zoomstufe auch der
richtige Kartenausschnitt dargestellt und klar ist welche Kacheln daneben
darzustellen ist wird.Bei OSM ist eine solche Kachel eine PNG-Grafik mit 256x256
Pixeln und je nach Zoomstufe ist eine unterschiedliche Anzahl solcher 
Kacheln/Tiles notwendig um die ganze Welt abzubilden. Da je Zoomstufe sich die
Anzahl der benötigten Kacheln vervierfacht ist bei den meisten Diensten bei
Zoomlevel 18 Schluß, OSM geht bis Zoomlevel 19.
Um die einzelnen Kacheln beim tilemap-Server abzufragen braucht man die
Zoomstufe, einen X und einen Y-Wert wobei dies alles ganzzahlige Werte sind.
Aufgerufen von den Servern werden die Kacheln dann nach dem Muster:
"http://servername/Zoom/X/Y.png" Den Fernsehturm mit Zoomstufe 18 findet man
z.B. bei Openstreetmap hier:https://tile.openstreetmap.org/18/140836/85970.png

Die Funktion arbeitet hier auf die Art und Weise, daß man 2 durch ein 
Freizeichen getrennte Zahlen eingibt. Handelt es sich bei den angegebenen Zahlen
um "Kommazahlen" welche allerdings mit Punkt anzugeben sind 
(Bsp: 52.520803 13.4088653 ) geht die Funktion davon aus, daß es sich um 
Koordinaten in Dezimalgrad handelt und sofern es gültige Koordinaten sind 
erfolgt eine Ausgabe der X und Y Werte für die Zoomstufen und 1-30.
(Positive Zahlen stehen für Nord und Ost, negative für Süd und West)

Handelt es sich bei den beiden Zahlen um Ganzzahlen wird davon ausgegangen, daß
es sich um X und Y Werte handelt und es werde für alle Zoomstufen von 1-30
Koordinaten in Dezimalminuten und Dezimalgrad ausgegeben, sofern dies sinnvolle
Koordinaten ergibt.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        text = text.split()
        if "." in text[0] and len(text) == 2:
            for zoom in range(30, 0, -1):
                try:
                    la = float(text[0])
                    lo = float(text[1])
                    if not la < -180 and not la > 180 and not lo < -180 and not lo > 180:
                        x, y = dec_to_maptiles(la, lo, zoom)
                        Ausgabe.insert(1.0, "Zoom:{:>2}  X:{:<10} Y:{}\n".format(zoom, x, y))
                except ValueError:
                    pass
            Ausgabe.insert(1.0, "DEC -> Maptiles\n", "bu")
        elif len(text) == 2:
            for zoom in range(30, 0, -1):
                try:
                    la, lo = maptiles_to_dec(int(text[0]), int(text[1]), zoom)
                    if not la < -180 and not la > 180 and not lo < -180 and not lo > 180:
                        Ausgabe.insert(1.0, "Zoom:{:>2} DEG: {:<23} DEC: {} {}\n".format(zoom, dec_to_deg(la, lo),
                                                                                         round(la, 5), round(lo, 5)))
                except ValueError:
                    pass
            Ausgabe.insert(1.0, "Maptiles->DEG,DEC\n", "bu")
        else:
            Ausgabe.insert(1.0, "Zahlen konnten nicht ermittelt werden!\n", "re")


def quadtreekoordinaten():
    hilfetext = """HILFE: [Quadtree-/Quadkeykoordinaten]
Diese Koordinatenkodierung spielt in der alltäglichen Praxis eigentlich
kaum noch ein Rolle, außer scheinbar bei bing-maps und beim Geocaching.
Sie dient ähnlich wie das Maptiles-System dazu Grafikdateien für
unterschiedliche Zoomstufen einer Karte zu adressieren.
Die Länge der Zahl entspricht hier zugleich auch dem Detailgrad bzw.
der Zoomstufe. Es finden nur die Zahlen 0,1,2 und 3 Verwendung, wobei
die 0 den Nordwestlichen Quadranten, 1 den Nordöstlichen, 2 SW und 3 SO.
Ein kleines Beispiel: 230 würde bedeuten es geht im südwestlichen 
Quadranten (2) um den südöstlichen Quadranten(3) und in diesem wiederum
um den nordwestlichen Quadranten.
Je länger also diese Zahlenreihe aus 0,1,2 und 3 wird um so genauer wird
ein bestimmter Ort angegeben.
Weitere Infos gibt es unter folgendem Link zu finden:
https://docs.microsoft.com/en-us/bingmaps/articles/bing-maps-tile-system

Die Funktion ermittelt aus einer Quadtreekoordinate die Maptileskoordinaten
und die WGS-Koordinaten.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        tilex = 0
        tiley = 0
        quadkey = text
        fehler = 0
        zoom = len(quadkey)
        for i in range(zoom, 0, -1):
            mask = 1 << (i - 1)
            if quadkey[zoom - i] == "0":
                continue
            if quadkey[zoom - i] == "1":
                tilex |= mask
                continue
            if quadkey[zoom - i] == "2":
                tiley |= mask
                continue
            if quadkey[zoom - i] == "3":
                tilex |= mask
                tiley |= mask
                continue
            else:
                fehler += 1
        la, lo = maptiles_to_dec(tilex, tiley, zoom)
        if fehler == 0:
            Ausgabe.insert(1.0, "DEG: {}\n".format(dec_to_deg(la, lo)))
            Ausgabe.insert(1.0, "DEC: {} {}\n".format(round(la, 5), round(lo, 5)))
            Ausgabe.insert(1.0, "Maptiles: X:{} Y:{} Zoom:{}\n".format(tilex, tiley, zoom))
        else:
            Ausgabe.insert(1.0,
                           "Es konnte keine gültige Quadtree-Koordinate erkannt werden.\n"
                           "(eine Zahl die nur die Ziffern 0,1,2,3 enthält)\n")


def chronogramm():
    hilfetext = """HILFE: [Chronogramm/ römische Ziffern zählen]
Ein Chronogramm (oder Eteostichon) ist ein Satzteil, ein Satz, ein Sinnspruch
oder eine Inschrift, meist ein Vers in lateinischer Sprache, in dem diejenigen
Buchstaben, die auch als römische Zahlzeichen gelesen werden können 
(I, V, X, L, C, D, M), in ihrer Summe die Jahreszahl des Ereignisses angeben,
auf das sich der Text bezieht. Entscheidend ist allein die Summe der
Zahlenwertbuchstaben, die sonst bei römischen Zahlen übliche Subtraktion
kleinerer Zahlenwerte von folgenden größeren erfolgt nicht.
Die Zahlbuchstaben sind meist hervorgehoben, etwa durch Großschreibung oder
Verdickung der Buchstaben bzw. durch farbliche Abhebung mittels Rötung oder
Vergoldung. Eine Besonderheit bilden Krypto(chrono)gramme, bei denen die
Zahlbuchstaben nicht gekennzeichnet sind und "verborgen" bleiben.

Bei der einfachen Analyse werden hier die Buchstaben I(1),V(5),X(10),L(50),
C(100), D(500), M(1000) berücksichtigt und addiert, bei der erweiterten
Analyse wird zunächst einmal berücksichtigt, daß im Lateinischen Alphabet
der Buchstabe J als I und der Buchstabe U als V geschrieben wird. Außerdem
erfolgt wird in der extremen Variante auch noch W=10(V+V) und Y=2(I+I)
berücksichtigt. Desweiteren wird auch für jeden relevanten Buchstaben
einzeln noch einmal die Anzahl und Summe angezeigt.
Eine Unterscheidung zwischen Klein- und Großschreibung findet nicht statt.
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        text = text.upper()
        i, v, x, ll, c, d, m, y, w, u, j = 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        for r_chr in text:
            if r_chr == "I":
                i += 1
            if r_chr == "V":
                v += 1
            if r_chr == "X":
                x += 1
            if r_chr == "L":
                ll += 1
            if r_chr == "C":
                c += 1
            if r_chr == "D":
                d += 1
            if r_chr == "M":
                m += 1
            if r_chr == "U":
                u += 1
            if r_chr == "J":
                j += 1
            if r_chr == "Y":
                y += 1
            if r_chr == "W":
                w += 1
        sum_einfach = i + (v * 5) + (x * 10) + (ll * 50) + (c * 100) + (d * 500) + (m * 1000)
        sum_erweitert = sum_einfach + (u * 5) + j
        sum_extrem = sum_erweitert + (y * 2) + (w * 10)
        Ausgabe.insert(1.0, "Summe extrem(inkl.J,U,Y,W): {}\n".format(sum_extrem))
        Ausgabe.insert(1.0, "Summe erweitert(inkl. I,U): {}\n".format(sum_erweitert))
        Ausgabe.insert(1.0, "Summe einfach(I,V,X,L,C,D,M): {}\n".format(sum_einfach))
        Ausgabe.insert(1.0, "W(V+V=10):{:5}x \tSumme W: {}\n".format(w, w * 10), "gr")
        Ausgabe.insert(1.0, " Y(I+I=2):{:5}x \tSumme Y: {}\n".format(y, y * 2), "gr")
        Ausgabe.insert(1.0, "   U(V=5):{:5}x \tSumme U: {}\n".format(u, u * 5), "gr")
        Ausgabe.insert(1.0, "   J(I=1):{:5}x \tSumme U: {}\n".format(j, j), "gr")
        Ausgabe.insert(1.0, "  M(1000):{:5}x \tSumme M: {}\n".format(m, m * 1000), "gr")
        Ausgabe.insert(1.0, "   D(500):{:5}x \tSumme D: {}\n".format(d, d * 500), "gr")
        Ausgabe.insert(1.0, "   C(100):{:5}x \tSumme C: {}\n".format(c, c * 100), "gr")
        Ausgabe.insert(1.0, "    L(50):{:5}x \tSumme L: {}\n".format(ll, ll * 50), "gr")
        Ausgabe.insert(1.0, "    X(10):{:5}x \tSumme X: {}\n".format(x, x * 10), "gr")
        Ausgabe.insert(1.0, "     V(5):{:5}x \tSumme V: {}\n".format(v, v * 5), "gr")
        Ausgabe.insert(1.0, "     I(1):{:5}x \tSumme I: {}\n".format(i, i), "gr")


def adfgx_kodieren():
    hilfetext = """HILFE: [ADFGX kodieren]
Die ADFGX-Chiffre arbeitet mit zwei Passwörtern, wobei jedes für je einen 
Kodierungsschritt verwendet wird. Das erste wird benutzt um eine Variation
der Polybios-Kodierung mit einem 5x5 Quadrat und J=I durchzuführen bei 
welcher die Zahlen 1-5 durch die Buchstaben ADFGX ersetzt werden. 
Mit dem Text "Ein Beispiel",dem Passwort "PASSWORT" und einem
mit A->Z aufgefülltem Schlüsselquadrat ergibt der erste Schritt z.B. die
Zeichenfolge: "FA FX GG DF FA FX AF AA FX FA GD". Nun kommt das zweite Passwort
zum Einsatz als Beispiel hier:"Tester". Zunächst einmal wird die Zeichenfolge
 5 1 4 6 2 3    in der Breite des Passwort Zeilenweise darunter geschrieben,
 T E S T E R    nun werden diese Spalten dem Passwort entsprechend 
 F A F X G G    alphabetisch sortiert und dann von oben nach unten abgelesen.
 D F F A F X    Im Beispiel fängt es also mit der Spalte 1 dem E an dann das
 A F A A F X    zweite E, dann R usw. was dann als kodierten Text, welcher
 F A G D        typischer Weise in 5er-Blöcken ausgegeben wird folgendes
                ergibt: AFFAG FFGXX FFAGF DAFXA AD ergibt.
Die beiden Varianten, welche ausgegeben werden, unterscheiden sich nur
darin, wie das Schlüsselquadrat im ersten Kodierungsschritt aufgefüllt
wird. Entweder in alphabetischer Reihenfolge A->Z oder umgekehrt Z->A. 
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        rn = ["AA", "AD", "AF", "AG", "AX", "DA", "DD", "DF", "DG", "DX", "FA", "FD", "FF", "FG", "FX", "GA", "GD",
              "GF", "GG", "GX", "XA", "XD", "XF", "XG", "XX"]
        alpha_az = "ABCDEFGHIKLMNOPQRSTUVWXYZ"  # j wird durch i ersetzt
        alpha_za = "ZYXWVUTSRQPONMLKIHGFEDCBA"
        text = text.upper()
        text = text.replace("J", "I")
        pw = pw.upper()
        pw = pw.replace("J", "I")
        pw = pw.split(",")
        if len(pw) != 2:
            Ausgabe.insert(1.0, "Es es werden genau zwei durch Komma getrennte Passwörter benötigt!\n", "re")
            return
        pw[0] = pw[0].strip()
        pw[1] = pw[1].strip()
        pw1az = ""
        for b in pw[0] + alpha_az:
            if b in alpha_az and b not in pw1az:
                pw1az += b
        pw1za = ""
        for b in pw[0] + alpha_za:
            if b in alpha_za and b not in pw1za:
                pw1za += b
        pw2 = ""
        for i in pw[1]:
            if i in alpha_az:
                pw2 += i
        klartext = ""
        for i in text:
            if i in alpha_az:
                klartext += i
        w_baz = {}
        for i in range(25):
            w_baz[pw1az[i]] = rn[i]
        w_bza = {}
        for i in range(25):
            w_bza[pw1za[i]] = rn[i]
        ctext1az = ""
        for b in klartext:
            ctext1az += w_baz[b]
        print(ctext1az)
        ctext1za = ""
        for b in klartext:
            ctext1za += w_bza[b]
        ctext2az = []
        for i in range(len(pw2)):
            ctext2az.append([pw2[i] + str(i + 10)])
        for i in range(len(ctext1az)):
            ctext2az[i % len(pw2)].append(ctext1az[i])
        ctext2az.sort()
        ausgabe_az = ""
        z = 1
        for i in ctext2az:
            for j in range(len(i) - 1):
                if z == 5:
                    ausgabe_az += i[j + 1] + " "
                    z = 1
                else:
                    ausgabe_az += i[j + 1]
                    z += 1
        ctext2za = []
        for i in range(len(pw2)):
            ctext2za.append([pw2[i] + str(i + 10)])
        for i in range(len(ctext1za)):
            ctext2za[i % len(pw2)].append(ctext1za[i])
        ctext2za.sort()
        ausgabe_za = ""
        z = 1
        for i in ctext2za:
            for j in range(len(i) - 1):
                if z == 5:
                    ausgabe_za += i[j + 1] + " "
                    z = 1
                else:
                    ausgabe_za += i[j + 1]
                    z += 1
        Ausgabe.insert(1.0, ausgabe_za + "\n")
        Ausgabe.insert(1.0, "kodiert mit Variante Z-A:\n")
        Ausgabe.insert(1.0, ausgabe_az + "\n")
        Ausgabe.insert(1.0, "kodiert mit Variante A-Z:\n")
        Ausgabe.insert(1.0, "Passwort 2: {}\n".format(pw2), "gr")
        Ausgabe.insert(1.0, "Passwort 1: {}\n".format(pw[0]), "gr")


def adfgx_dekodieren():
    hilfetext = """HILFE: [ADFGX dekodieren]
Die ADFGX-Chiffre arbeitet mit zwei Passwörtern, wobei jedes für je einen 
Kodierungsschritt verwendet wird. Das erste wird benutzt um eine Variation
der Polybios-Kodierung mit einem 5x5 Quadrat und J=I durchzuführen bei 
welcher die Zahlen 1-5 durch die Buchstaben ADFGX ersetzt werden. 
Mit dem Text "Ein Beispiel",dem Passwort "PASSWORT" und einem
mit A->Z aufgefülltem Schlüsselquadrat ergibt der erste Schritt z.B. die
Zeichenfolge: "FA FX GG DF FA FX AF AA FX FA GD". Nun kommt das zweite Passwort
zum Einsatz als Beispiel hier:"Tester". Zunächst einmal wird die Zeichenfolge
 5 1 4 6 2 3    in der Breite des Passwort Zeilenweise darunter geschrieben,
 T E S T E R    nun werden diese Spalten dem Passwort entsprechend 
 F A F X G G    alphabetisch sortiert und dann von oben nach unten abgelesen.
 D F F A F X    Im Beispiel fängt es also mit der Spalte 1 dem E an dann das
 A F A A F X    zweite E, dann R usw. was dann als kodierten Text, welcher
 F A G D        typischer Weise in 5er-Blöcken ausgegeben wird folgendes
                ergibt: AFFAG FFGXX FFAGF DAFXA AD ergibt.
Die beiden Varianten, welche ausgegeben werden, unterscheiden sich nur
darin, wie das Schlüsselquadrat im ersten Kodierungsschritt aufgefüllt
wird. Entweder in alphabetischer Reihenfolge A->Z oder umgekehrt Z->A. 
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        rn = ["AA", "AD", "AF", "AG", "AX", "DA", "DD", "DF", "DG", "DX", "FA", "FD", "FF", "FG", "FX", "GA", "GD",
              "GF", "GG", "GX", "XA", "XD", "XF", "XG", "XX"]
        alpha_az = "ABCDEFGHIKLMNOPQRSTUVWXYZ"  # j wird durch i ersetzt
        alpha_za = "ZYXWVUTSRQPONMLKIHGFEDCBA"
        text = text.upper()
        text = text.replace("J", "I")
        pw = pw.upper()
        pw = pw.replace("J", "I")
        pw = pw.split(",")
        if len(pw) != 2:
            Ausgabe.insert(1.0, "Es es werden genau zwei durch Komma getrennte Passwörter benötigt!\n", "re")
            return
        pw[0] = pw[0].strip()
        pw[1] = pw[1].strip()
        pw1az = ""
        for b in pw[0] + alpha_az:
            if b in alpha_az and b not in pw1az:
                pw1az += b
        pw1za = ""
        for b in pw[0] + alpha_za:
            if b in alpha_za and b not in pw1za:
                pw1za += b
        pw2 = ""
        for i in pw[1]:
            if i in alpha_az:
                pw2 += i
        ctext = ""
        for i in text:
            if i in alpha_az:
                ctext += i
        w_baz = {}
        for i in range(25):
            w_baz[rn[i]] = pw1az[i]
        w_bza = {}
        for i in range(25):
            w_bza[rn[i]] = pw1za[i]
        ret = ['_'] * len(ctext)
        lt, lp = len(ctext), len(pw2)
        t1 = [(pw2[i], i) for i in range(len(pw2))]
        ind = [q[1] for q in sorted(t1)]
        upto = 0
        for i in range(len(pw2)):
            tic = int(lt / lp)
            if ind[i] < lt % lp:
                tic += 1
            ret[ind[i]::lp] = ctext[upto:upto + tic]
            upto += tic
        ctext = ''.join(ret)
        klartext_az = ""
        for i in range(0, len(ctext), 2):
            bi = ctext[i:i + 2]
            if bi in w_baz:
                klartext_az += w_baz[bi]
        klartext_za = ""
        for i in range(0, len(ctext), 2):
            bi = ctext[i:i + 2]
            if bi in w_bza:
                klartext_za += w_bza[bi]
        Ausgabe.insert(1.0, klartext_za + "\n")
        Ausgabe.insert(1.0, "dekodiert mit Variante Z-A:\n")
        Ausgabe.insert(1.0, klartext_az + "\n")
        Ausgabe.insert(1.0, "dekodiert mit Variante A-Z:\n")
        Ausgabe.insert(1.0, "Passwort 2: {}\n".format(pw2), "gr")
        Ausgabe.insert(1.0, "Passwort 1: {}\n".format(pw[0]), "gr")


def adfgvx_kodieren():
    hilfetext = """HILFE: [ADFGVX kodieren]
Die ADFGVX-Chiffre erweitert das 5x5-Schlüsselquadrat der ADFGX-Chiffre
ersten Kodierungsschritt auf 6x6 so, daß das komplette Alphabet und die
Zahlen 0-9 verwendet werden können. Die beiden ausgegebenen Varianten
unterscheiden sich in der Variante wie das Schlüsselquadrat aufgefüllt
wird (A->Z + 0->9 oder 9->0 + Z->A). 
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        rn = ["AA", "AD", "AF", "AG", "AV", "AX", "DA", "DD", "DF", "DG", "DV", "DX", "FA", "FD", "FF", "FG", "FV",
              "FX", "GA", "GD", "GF", "GG", "GV", "GX", "VA", "VD", "VF", "VG", "VV", "VX", "XA", "XD", "XF", "XG",
              "XV", "XX"]
        alpha_az09 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
        alpha_90za = "9876543210ZYXWVUTSRQPONMLKJIHGFEDCBA"
        text = text.upper()
        pw = pw.upper()
        pw = pw.split(",")
        if len(pw) != 2:
            Ausgabe.insert(1.0, "Es es werden genau zwei durch Komma getrennte Passwörter benötigt!\n", "re")
            return
        pw[0] = pw[0].strip()
        pw[1] = pw[1].strip()
        pw1az09 = ""
        for b in pw[0] + alpha_az09:
            if b in alpha_az09 and b not in pw1az09:
                pw1az09 += b
        pw190za = ""
        for b in pw[0] + alpha_90za:
            if b in alpha_90za and b not in pw190za:
                pw190za += b
        pw2 = ""
        for i in pw[1]:
            if i in alpha_az09:
                pw2 += i
        klartext = ""
        for i in text:
            if i in alpha_az09:
                klartext += i
        w_baz09 = {}
        for i in range(36):
            w_baz09[pw1az09[i]] = rn[i]
        wb90za = {}
        for i in range(36):
            wb90za[pw190za[i]] = rn[i]
        ctext1az09 = ""
        for b in klartext:
            ctext1az09 += w_baz09[b]
        ctext190za = ""
        for b in klartext:
            ctext190za += wb90za[b]
        ctext2az09 = []
        for i in range(len(pw2)):
            ctext2az09.append([pw2[i] + str(i + 10)])
        for i in range(len(ctext1az09)):
            ctext2az09[i % len(pw2)].append(ctext1az09[i])
        ctext2az09.sort()
        ausgabe_az09 = ""
        z = 1
        for i in ctext2az09:
            for j in range(len(i) - 1):
                if z == 5:
                    ausgabe_az09 += i[j + 1] + " "
                    z = 1
                else:
                    ausgabe_az09 += i[j + 1]
                    z += 1
        ctext290za = []
        for i in range(len(pw2)):
            ctext290za.append([pw2[i] + str(i + 10)])
        for i in range(len(ctext190za)):
            ctext290za[i % len(pw2)].append(ctext190za[i])
        ctext290za.sort()
        ausgabe_90za = ""
        z = 1
        for i in ctext290za:
            for j in range(len(i) - 1):
                if z == 5:
                    ausgabe_90za += i[j + 1] + " "
                    z = 1
                else:
                    ausgabe_90za += i[j + 1]
                    z += 1
        Ausgabe.insert(1.0, ausgabe_90za + "\n")
        Ausgabe.insert(1.0, "kodiert mit Variante 9-0,Z-A:\n")
        Ausgabe.insert(1.0, ausgabe_az09 + "\n")
        Ausgabe.insert(1.0, "kodiert mit Variante A-Z,0-9:\n")
        Ausgabe.insert(1.0, "Passwort 2: {}\n".format(pw2), "gr")
        Ausgabe.insert(1.0, "Passwort 1: {}\n".format(pw[0]), "gr")


def adfgvx_dekodieren():
    hilfetext = """HILFE: [ADFGVX dekodieren]
Die ADFGVX-Chiffre erweitert das 5x5-Schlüsselquadrat der ADFGX-Chiffre
ersten Kodierungsschritt auf 6x6 so, daß das komplette Alphabet und die
Zahlen 0-9 verwendet werden können. Die beiden ausgegebenen Varianten
unterscheiden sich in der Variante wie das Schlüsselquadrat aufgefüllt
wird (A->Z + 0->9 oder 9->0 + Z->A). 
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    text = eingabetext.rstrip()
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if text == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        rn = ["AA", "AD", "AF", "AG", "AV", "AX", "DA", "DD", "DF", "DG", "DV", "DX", "FA", "FD", "FF", "FG", "FV",
              "FX", "GA", "GD", "GF", "GG", "GV", "GX", "VA", "VD", "VF", "VG", "VV", "VX", "XA", "XD", "XF", "XG",
              "XV", "XX"]
        alpha_az09 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
        alpha_90za = "9876543210ZYXWVUTSRQPONMLKJIHGFEDCBA"
        text = text.upper()
        pw = pw.upper()
        pw = pw.split(",")
        if len(pw) != 2:
            Ausgabe.insert(1.0, "Es es werden genau zwei durch Komma getrennte Passwörter benötigt!\n", "re")
            return
        pw[0] = pw[0].strip()
        pw[1] = pw[1].strip()
        pw1az09 = ""
        for b in pw[0] + alpha_az09:
            if b in alpha_az09 and b not in pw1az09:
                pw1az09 += b
        pw190za = ""
        for b in pw[0] + alpha_90za:
            if b in alpha_90za and b not in pw190za:
                pw190za += b
        pw2 = ""
        for i in pw[1]:
            if i in alpha_az09:
                pw2 += i
        ctext = ""
        for i in text:
            if i in alpha_az09:
                ctext += i
        w_baz09 = {}
        for i in range(36):
            w_baz09[rn[i]] = pw1az09[i]
        wb90za = {}
        for i in range(36):
            wb90za[rn[i]] = pw190za[i]
        ret = ['_'] * len(ctext)
        lt, lp = len(ctext), len(pw2)
        t1 = [(pw2[i], i) for i in range(len(pw2))]
        ind = [q[1] for q in sorted(t1)]
        upto = 0
        for i in range(len(pw2)):
            tic = int(lt / lp)
            if ind[i] < lt % lp:
                tic += 1
            ret[ind[i]::lp] = ctext[upto:upto + tic]
            upto += tic
        ctext = ''.join(ret)
        klartext_az09 = ""
        for i in range(0, len(ctext), 2):
            bi = ctext[i:i + 2]
            if bi in w_baz09:
                klartext_az09 += w_baz09[bi]
        klartext_90za = ""
        for i in range(0, len(ctext), 2):
            bi = ctext[i:i + 2]
            if bi in wb90za:
                klartext_90za += wb90za[bi]
        Ausgabe.insert(1.0, klartext_90za + "\n")
        Ausgabe.insert(1.0, "dekodiert mit Variante 0-0,Z-A:\n")
        Ausgabe.insert(1.0, klartext_az09 + "\n")
        Ausgabe.insert(1.0, "dekodiert mit Variante A-Z,0-9:\n")
        Ausgabe.insert(1.0, "Passwort 2: {}\n".format(pw2), "gr")
        Ausgabe.insert(1.0, "Passwort 1: {}\n".format(pw[0]), "gr")


def zahlen_roemisch_arabisch_umwandeln():
    hilfetext = """HILFE: [Römische in Arabische Zahlen umwandeln und umgekehrt]
Es werden römische Zahlen in arabische umgewandelt und umgekehrt, die Funktion
arbeitet dabei bei der Umwandlung von arabisch zu römisch mit Werten bis
maximal 500000. Es werden folgende Zeichen verwendet: I=1, V=5, X=10, L=50,
C=100, D=500, M=1000, \u2181=5000, \u2182=10000, \u2187=50000, \u2188=100000
Etwas Vorsicht sollte bei einer Umwandlung von römischen in arabische Zahlen
geboten sein, wenn mit untypischen Schreibweisen gearbeitet wird bei welchen
mehr als ein Zeichen von dem nachfolgenden Zeichen abgezogen werden soll.
Die eigentlich inkorrekte Schreibweise IIX für die Zahl 8 wird hier die Zahl
10 als Ergebnis haben (+1-1+10), dafür wird aber allerdings die ebenfalls
falsche Schreibweise IM genauso als 999 wie die korrekte Schreibweise CMXCIX
erkannt.
"""
    rza = {'I': 1, 'V': 5, 'X': 10, 'L': 50, 'C': 100, 'D': 500, 'M': 1000, '\u2181': 5000, '\u2182': 10000,
           '\u2187': 50000, '\u2188': 100000}
    azr = [(100000, '\u2188'), (90000, '\u2182\u2188'), (50000, '\u2187'), (40000, '\u2182\u2187'),
           (10000, '\u2182'), (9000, 'M\u2182'), (5000, '\u2181'), (4000, 'M\u2181'), (1000, 'M'), (900, 'CM'),
           (500, 'D'),
           (400, 'CD'), (100, 'C'), (90, 'XC'), (50, 'L'), (40, 'XL'), (10, 'X'), (9, 'IX'), (5, 'V'), (4, 'IV'),
           (1, 'I')]
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    rz = eingabetext.rstrip()
    if rz == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        rz = rz.upper()
        try:
            az = 0
            for i in range(len(rz)):
                if i == len(rz) - 1:
                    az += rza[rz[i]]
                    Ausgabe.insert(1.0, "{} = {}\n".format(rz, az))
                else:
                    if rza[rz[i]] < rza[rz[i + 1]]:
                        az -= rza[rz[i]]
                    else:
                        az += rza[rz[i]]
        except KeyError:
            try:
                zahl = int(rz)
                if zahl > 500000:
                    Ausgabe.insert(1.0, "arabische Zahlen größer als 500000 mag ich nicht in römische Zahlen!\n", "re")
                    return
                rom = ""
                for az, romz in azr:
                    count = zahl // az
                    zahl -= az * count
                    rom += romz * count
                Ausgabe.insert(1.0, "{} = {}\n".format(rz, rom))
            except ValueError:
                Ausgabe.insert(1.0, "Es konnte keine römische oder arabische Zahl erkannt werden!\n", "re")


def euler_suche():
    hilfetext = """HILFE: [Eulersche Zahl - Nachkommastellensuche]
Für die eingegebene Zahl/Zahlenreihe X wird versucht die
entsprechende X. Nachkommastelle auszugeben und das erst
Vorkommen der Zahlenreihe X innerhalb der Nachkommastellen
von e (2.71828182845904523.....) zu ermitteln.

Da es deutlich schnneller geht mit einer vorgefertigten
Datei zu suchen als die Nachkommastellen zu berechnen 
wird die Datei e.txt im Unterverzeichnis "data" benötigt.
Diese Datei enthält die Zahl e mit den ersten 10 Millionen
Nachkommastellen. Wer mehr Stellen braucht, kann sich mit 
dem Tool y-cruncher (http://numberworld.org/y-cruncher/) 
auch eine Datei mit deutlich mehr Nachkommastellen erstellen
und e.txt damit ersetzen. (Bei 1 Millarde Stellen ist
die Datei dann allerdings schon knapp 1 GB groß und
die Abfrage dauert auch etwas länger)
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            eread = open("./data/e.txt", "r")
        except FileNotFoundError:
            Ausgabe.insert(1.0, hilfetext + "\n")
        else:
            estr = ""
            for zeile in eread:
                estr = estr + zeile.rstrip()
            eread.close()
            elen = len(estr) - 2
            try:
                zahlx = int(eingabetext)
            except ValueError:
                Ausgabe.insert(1.0, "Sorry aber ohne gültige Zahleneingabe funktioniert das nicht!\n", "re")
            else:
                pos = estr.find(eingabetext)
                if pos == -1:
                    Ausgabe.insert(1.0, "Zahlenreihe in {} Nachkommastellen nicht zu finden.\n\n".format(elen), "re")
                else:
                    Ausgabe.insert(1.0,
                                   "20 Stellen ab {}. Nachkommstelle: {}...\n\n".format(pos - 1, estr[pos:pos + 20]))
                    Ausgabe.insert(1.0, 'erstes Vorkommen von Zahlenfolge "{}" ab {}. Nachkommastelle\n'.format(
                        eingabetext.rstrip(), pos - 1))
                if elen >= zahlx > 0:
                    Ausgabe.insert(1.0, "20 Stellen ab {}. Nachkommstelle:"
                                        " {}...\n\n".format(zahlx, estr[zahlx + 1:zahlx + 21]))
                    Ausgabe.insert(1.0, "Die {}. Nachkommstelle: lautet {}\n".format(zahlx, estr[zahlx + 1]))
                else:
                    Ausgabe.insert(1.0, "Die verwendete e.txt kennt leider nur {} Nachkommstellen.\n\n".format(elen),
                                   "re")
                Ausgabe.insert(1.0, "e (Eulersche Zahl)\n\n", "gr")


def goldener_schnitt_suche():
    hilfetext = """HILFE: [phi(Goldener Schnitt) Nachkommastellensuche]
Für die eingegebene Zahl/Zahlenreihe X wird versucht die
entsprechende X. Nachkommastelle auszugeben und das erst
Vorkommen der Zahlenreihe X innerhalb der Nachkommastellen
von phi (1.6180339887498948482045...) zu ermitteln.

Da es deutlich schnneller geht mit einer vorgefertigten
Datei zu suchen als die Nachkommastellen zu berechnen 
wird die Datei phi.txt im Unterverzeichnis "data" benötigt.
Diese Datei enthält die Zahl phi mit den ersten 10 Millionen
Nachkommastellen. Wer mehr Stellen braucht, kann sich mit 
dem Tool y-cruncher (http://numberworld.org/y-cruncher/) 
auch eine Datei mit deutlich mehr Nachkommastellen erstellen
und phi.txt damit ersetzen. (Bei 1 Millarde Stellen ist
die Datei dann allerdings schon knapp 1 GB groß und
die Abfrage dauert auch etwas länger)
"""
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, hilfetext + "\n")
    else:
        try:
            phiread = open("./data/phi.txt", "r")
        except ValueError:
            Ausgabe.insert(1.0, hilfetext + "\n")
        else:
            phistr = ""
            for zeile in phiread:
                phistr = phistr + zeile.rstrip()
            phiread.close()
            philen = len(phistr) - 2
            try:
                zahlx = int(eingabetext)
            except ValueError:
                Ausgabe.insert(1.0, "Sorry aber ohne gültige Zahleneingabe funktioniert das nicht!\n", "re")
            else:
                pos = phistr.find(eingabetext)
                if pos == -1:
                    Ausgabe.insert(1.0, "Zahlenreihe in {} Nachkommastellen nicht zu finden.\n\n".format(philen), "re")
                else:
                    Ausgabe.insert(1.0,
                                   "20 Stellen ab {}. Nachkommstelle: {}...\n\n".format(pos - 1, phistr[pos:pos + 20]))
                    Ausgabe.insert(1.0, 'erstes Vorkommen von Zahlenfolge "{}" ab {}. Nachkommastelle\n'.format(
                        eingabetext.rstrip(), pos - 1))
                if philen >= zahlx > 0:
                    Ausgabe.insert(1.0, "20 Stellen ab {}. Nachkommstelle:"
                                        " {}...\n\n".format(zahlx, phistr[zahlx + 1:zahlx + 21]))
                    Ausgabe.insert(1.0, "Die {}. Nachkommstelle: lautet {}\n".format(zahlx, phistr[zahlx + 1]))
                else:
                    Ausgabe.insert(1.0, "Die verwendete pi.txt kennt leider nur {} Nachkommstellen.\n".format(philen),
                                   "re")
                Ausgabe.insert(1.0, "Phi (Goldener Schnitt)\n\n", "gr")


def url_decode():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [URL-decode]
Nachdem Groundspeak nun inzwischen sämtliche Bilddateien
über einen Proxy umleitet bevor sie im Listing erscheinen
wird es manchmal schwer die ursprüngliche URL und/oder
den Dateinamen des Bildes noch lesen zu können.
Die URL hat dort nun jeweils folgendes Muster:
https://imgproxy.geocaching.com/......?url=.....
wobei nach dem ?url= dann die ursprüngliche Bild-URL
folgt, allerdings wird dabei dann aus 
http:// folgendes http%3A%2F%2F und um genau dieses
wieder normal lesbar zu machen dient diese Funktion\n\n""")
    else:
        atxt = urllib_parse_unquote(eingabetext)
        Ausgabe.insert(1.0, atxt + "\n")
        Ausgabe.insert(1.0, "dekodierte URL:\n", "bu")


def reversewig():
    seperator = ("|,", "_", "/", ";", ",")
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Reverse Wherigo zu Koordinaten]
Mit dem Reverse Wherigo hat -Waldmeister- eigentlich eine coole Sache
erfunden. Man hat anfangs keine Koordinaten sondern nur 3 Zahlen, welche
man nach Start des Wherigo-Cartridges eingibt und dann erfährt man wie weit
der Cache entfernt ist. Nun kann man immer wieder von unterschiedlichen
Positionen aus diese Entfernungsfragen durchführen und sich damit dem
Cache nähern. Je weniger Abfragen man braucht umso besser.
Leider gibt es inzwischen genügend Tools die genau wie diese Funktion
hier aus den 3 Zahlen direkt die Finalkoordinaten ermitteln können.
Leider??? Ja leider denn das führt auch dazu, das es inzwischen so extrem
viele dieser Reverse-Wherigos gibt wo sich die Owner anscheinend auch
denken "Die spielt doch sowieso keiner mehr normal..." anders kann ich
mir ganze Trails mit Reverse-Wherigos nicht erklären.

Um die Funktion zu nutzen braucht man nur die 3 Zahlen durch ein entsprechendes
Trennzeichen: | , _ / ; , oder Leerzeichen eingeben und auf den Knopp klicken
und bekommt Koordinaten. 

""" + "\n\n")
    else:
        se = ""
        for s in seperator:
            if s in eingabetext:
                se = s
        if se == "" and " " in eingabetext:
            se = " "
        if se == "":
            Ausgabe.insert(1.0, "Keine gültiges Trennzeichen (, ; / _ | oder Leerzeichen) erkannt!\n", "re")
        else:
            txt = eingabetext.split(se)
            if len(txt) == 3:
                error = 0
                for z in txt:
                    try:
                        int(z)
                    except ValueError:
                        Ausgabe.insert(1.0, "Bitte die Eingabezahlen überprüfen\n", "re")
                        error += 1
                if error == 0:
                    final = rwig_to_coords(txt[0], txt[1], txt[2])
                    Ausgabe.insert(1.0, "DEG: " + dec_to_deg(final[0], final[1]) + "\n")
                    Ausgabe.insert(1.0, "DEC: " + str(final[0]) + " " + str(final[1]) + "\n")
                    Ausgabe.insert(1.0, "WIG: " + txt[0] + ", " + txt[1] + ", " + txt[2] + "\n")

            else:
                Ausgabe.insert(1.0, "Es wurden nicht 3 Zahlen erkannt.\n", "re")


def base64_ascii():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.rstrip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [Base64 <-> ASCII]
Base64 ist ein Kodierungsverfahren, welches dazu verwendet wird
um beliebige Binärdaten nur Hilfe einer Zeichenkette aus A-Z,
a-z, 0-9, +, / sowie am Ende = übertragen zu können. Ein Einsatzzweck
dafür ist z.B. wenn bei EMails Dateianhänge verwendet werden, dort
werden nahezu alle Dateiformate base64-kodiert übertragen.
Auch bei dem einem oder anderen Mystery sind mir solche kodierten
Zeichenketten schon begegnet. Wenn am Ende einer Zeichenkette ein
oder zwei "="-Zeichen stehen ist die Wahrscheinlichkeit recht groß,
das hier base64 verwendet wurde. Das "="-Zeichen dient hier nämlich
als "Lückenfüller" am Ende.
Die Funktion hier versucht zunächst eine Dekodierung Base64->ASCII
gelingt dies nicht, erscheint ein Hinweis und der eingegeben Text
wird dann Base64-kodiert ausgegeben. 
""" + "\n\n")
    else:
        try:
            ascii_string = binascii.a2b_base64(eingabetext).decode()
            Ausgabe.insert(1.0, ascii_string + "\n")
            Ausgabe.insert(1.0, "Base64 -> ASCII:\n", "bu")
        except ValueError:
            base64_string = binascii.b2a_base64(eingabetext.encode())
            Ausgabe.insert(1.0, base64_string.decode() + "\n")
            Ausgabe.insert(1.0, "ASCII -> Base64:\n", "bu")
            Ausgabe.insert(1.0, "Umwandlung Base64 -> ASCII war nicht möglich.\n", "re")


def rail_encrypt(plain_text: str, rails: int):
    arr = [["" for _ in range(len(plain_text))] for _ in range(rails)]
    r = 0
    z = 0
    plus = True
    for b in plain_text:
        arr[r][z] = b
        z += 1
        if r + 1 == rails and plus:
            plus = False
            r -= 1
        elif r - 1 < 0 and not plus:
            plus = True
            r += 1
        elif plus:
            r += 1
        else:
            r -= 1
    out = ""
    for i in range(rails):
        for j in range(len(plain_text)):
            out += arr[i][j]
    return out


def jaegerzaun_encrypt():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.strip().replace("\n", " ")
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [encrypt Jägerzaun]
Jägerzaun (auch Railfence oder ZigZag-Chiffre genannt)
Bei dieser Chiffre wird kodiert, indem man einen Text im Zickzackmuster
in ein Feld aus z.B. 3 Zeilen und so vielen Spalten wie der Text lang ist
schreibt. Man beginnt in Spalte 1 - Zeile 1, dann geht es in Spalte 2 - Zeile 1
weiter danach Spalte 3 - Zeile 3, dann Spalte 4 - Zeile 2, Spalte 5 - Zeile 1 usw.
Danach werden die Buchstaben einfach Zeile für Zeile hintereinander geschrieben.
Unterschiedliche Varianten entstehen einfach dadurch, dass man mit unterschiedlich
vielen Zeilen arbeitet welche im Schlüsselfeld anzugeben ist.

Die Funktion erzeugt hierbei einmal eine Ausgabe bei welcher auch Leerzeichen
mitgeschrieben werden und eine Ausgabe wo zuvor die Leerzeichen entfernt werden.  
    """ + "\n\n")
    elif pw == "" or not pw.isdigit():
        Ausgabe.insert(1.0, "Bitte eine Zahl im Schlüsselfeld eingeben!!\n", "re")
    else:
        try:
            if int(pw) < 2:
                raise ValueError("Zahl zu klein")
            Ausgabe.insert(1.0, rail_encrypt(eingabetext.replace(" ", ""), int(pw)) + "\n")
            Ausgabe.insert(1.0, "ohne Leerzeichen\n", "bu")
            Ausgabe.insert(1.0, rail_encrypt(eingabetext, int(pw)) + "\n")
            Ausgabe.insert(1.0, "inkl. Leerzeichen\n", "bu")
        except ValueError:
            Ausgabe.insert(1.0, "Schlüsselzahl fehlerhaft oder kleiner als 2.\n", "re")


def rail_decrypt(cipher: str, rails: int):
    arr = [["_" for _ in range(len(cipher))] for _ in range(rails)]
    # cipher ins array reinbasteln
    x, y = 0, 0
    first_x = True
    for b in cipher:
        if x >= len(cipher) and y < rails:
            y += 1
            x = y
            first_x = True
        arr[y][x] = b
        if y == 0 or (first_x and y != rails - 1):
            x = x + (rails - y - 1) * 2
            first_x = False
        elif y == rails - 1 or first_x is False:
            x = x + (y * 2)
            first_x = True
    # dekodierten Text aus array holen
    out = ""
    x, y = 0, 0
    down = True
    for i in range(len(cipher)):
        out += arr[y][x]
        x += 1
        if down and y + 1 == rails:
            down = False
            y -= 1
        elif down:
            y += 1
        elif down is False and y == 0:
            down = True
            y += 1
        elif down is False:
            y -= 1
    return out


def jaegerzaun_decrypt():
    trennlinie()
    eingabetext = Eingabe.get(1.0, END)
    eingabetext = eingabetext.strip().replace("\n", " ")
    pw = PW_Eingabe.get()
    pw = pw.strip()
    if eingabetext == "":
        Ausgabe.insert(1.0, """HILFE: [decrypt Jägerzaun]
Jägerzaun (auch Railfence oder ZigZag-Chiffre genannt)
Bei dieser Chiffre wird kodiert, indem man einen Text im Zickzackmuster
in ein Feld aus z.B. 3 Zeilen und so vielen Spalten wie der Text lang ist
schreibt. Man beginnt in Spalte 1 - Zeile 1, dann geht es in Spalte 2 - Zeile 1
weiter danach Spalte 3 - Zeile 3, dann Spalte 4 - Zeile 2, Spalte 5 - Zeile 1 usw.
Danach werden die Buchstaben einfach Zeile für Zeile hintereinander geschrieben.
Unterschiedliche Varianten entstehen einfach dadurch, dass man mit unterschiedlich
vielen Zeilen arbeitet welche im Schlüsselfeld angegeben werden kann.

Die Funktion erzeugt hierbei einmal eine Ausgabe bei welcher auch Leerzeichen
mitgeschrieben werden und eine Ausgabe wo zuvor die Leerzeichen entfernt werden.  

Wird im Schlüsselfeld keine Zahl angegeben erfolgt automatisch die Dekodierung
für alle Zeilenanzahlen von 2-12.""" + "\n\n")
    elif pw == "":
        for i in range(12, 1, -1):
            Ausgabe.insert(1.0, f'{i:02} - {rail_decrypt(eingabetext.replace(" ", ""), i)}\n')
        Ausgabe.insert(1.0, "ohne Leerzeichen\n", "bu")
        for i in range(12, 1, -1):
            Ausgabe.insert(1.0, f'{i:02} - {rail_decrypt(eingabetext, i)}\n')
        Ausgabe.insert(1.0, "inkl. Leerzeichen\n", "bu")
    elif not pw.isdigit():
        Ausgabe.insert(1.0, "Bitte eine Zahl im Schlüsselfeld eingeben!!\n", "re")
    else:
        try:
            if int(pw) < 2:
                raise ValueError("Zahl zu klein")
            Ausgabe.insert(1.0, rail_decrypt(eingabetext.replace(" ", ""), int(pw)) + "\n")
            Ausgabe.insert(1.0, "ohne Leerzeichen\n", "bu")
            Ausgabe.insert(1.0, rail_decrypt(eingabetext, int(pw)) + "\n")
            Ausgabe.insert(1.0, "inkl. Leerzeichen\n", "bu")
        except ValueError:
            Ausgabe.insert(1.0, "Schlüsselzahl fehlerhaft oder kleiner als 2.\n", "re")


# ------------------------------------------------------------------------------------------
def knoeppe_aendern2():
    B44.config(text="Button88", command="", bg=bgcolor_default, cursor="")
    B45.config(text="Button89", command="", bg=bgcolor_default, cursor="")
    B46.config(text="Button90", command="", bg=bgcolor_default, cursor="")
    B47.config(text="Button91", command="", bg=bgcolor_default, cursor="")
    B48.config(text="Button92", command="", bg=bgcolor_default, cursor="")
    B49.config(text="Button93", command="", bg=bgcolor_default, cursor="")
    B50.config(text="Button94", command="", bg=bgcolor_default, cursor="")
    B51.config(text="Button95", command="", bg=bgcolor_default, cursor="")
    B52.config(text="Button96", command="", bg=bgcolor_default, cursor="")
    B53.config(text="Button97", command="", bg=bgcolor_default, cursor="")
    B54.config(text="Button98", command="", bg=bgcolor_default, cursor="")
    B55.config(text="Button99", command="", bg=bgcolor_default, cursor="")
    B56.config(text="Button100", command="", bg=bgcolor_default, cursor="")
    B57.config(text="Button101", command="", bg=bgcolor_default, cursor="")
    B58.config(text="Button102", command="", bg=bgcolor_default, cursor="")
    B59.config(text="Button103", command="", bg=bgcolor_default, cursor="")
    B60.config(text="Button104", command="", bg=bgcolor_default, cursor="")
    B61.config(text="Button105", command="", bg=bgcolor_default, cursor="")
    B62.config(text="Button106", command="", bg=bgcolor_default, cursor="")
    B63.config(text="Button107", command="", bg=bgcolor_default, cursor="")
    B64.config(text="Button108", command="", bg=bgcolor_default, cursor="")
    B65.config(text="_____Button109_____", command="", bg=bgcolor_default, cursor="")
    BC0.config(fg="#ffffff", bg="#000000")
    BC1.config(fg="#ffffff", bg="#000000")
    BC2.config(fg="#000000", bg="#ffffff")
    BC3.config(fg="#ffffff", bg="#000000")
    BC4.config(fg="#ffffff", bg="#000000")


def knoeppe_aendern1():
    B44.config(text="KENNYspeak kodieren", command=kenny_kodieren, bg='#FF897F', cursor='question_arrow', font=schrift)
    B45.config(text="KENNYspeak dekodieren", command=kenny_dekodieren, bg='#FF897F', cursor='question_arrow',
               font=schrift)
    B46.config(text="KENNYspeak raten", command=kenny_raten, bg='#FF897F', cursor='question_arrow', font=schrift)
    B47.config(text="Maptiles/Kachelkoord.", command=maptiles_kachelkoordinaten, bg='#FF59AF', cursor='question_arrow',
               font=schrift)
    B48.config(text="Quadtree/Quadkey", command=quadtreekoordinaten, bg='#FF59AF', cursor='question_arrow',
               font=schrift)
    B49.config(text="URL decode", command=url_decode, bg='#2FE94F', cursor='question_arrow', font=schrift)
    B50.config(text="T9-DE dekodieren", command=t9_de, bg="#ff3300", cursor='question_arrow', font=schrift)
    B51.config(text="T9-EN dekodieren", command=t9_en, bg="#ff3300", cursor='question_arrow', font=schrift)
    B52.config(text="Wortsuche-DE", command=wortsuche_de, bg="#33aa00", cursor='question_arrow', font=schrift)
    B53.config(text="Wortsuche-EN", command=wortsuche_en, bg="#33aa00", cursor='question_arrow', font=schrift)
    B54.config(text="Reverse-Wherigo", command=reversewig, bg="#FFA94F", cursor='question_arrow', font=schrift)
    B55.config(text="Base64<->ASCII", command=base64_ascii, bg="#7777ff", cursor='question_arrow', font=schrift)
    B56.config(text="Jägerzaun kodieren", command=jaegerzaun_encrypt, bg="#3388aa", cursor='question_arrow',
               font=schrift)
    B57.config(text="Jägerzaun dekodieren", command=jaegerzaun_decrypt, bg="#3388aa", cursor='question_arrow',
               font=schrift)
    B58.config(text="Button80", command="", bg=bgcolor_default, cursor="")
    B59.config(text="Button81", command="", bg=bgcolor_default, cursor="")
    B60.config(text="Button82", command="", bg=bgcolor_default, cursor="")
    B61.config(text="Button83", command="", bg=bgcolor_default, cursor="")
    B62.config(text="Button84", command="", bg=bgcolor_default, cursor="")
    B63.config(text="Button85", command="", bg=bgcolor_default, cursor="")
    B64.config(text="Button86", command="", bg=bgcolor_default, cursor="")
    B65.config(text="Button87", command="", bg=bgcolor_default, cursor="")
    BC0.config(fg="#ffffff", bg="#000000")
    BC1.config(fg="#000000", bg="#ffffff")
    BC2.config(fg="#ffffff", bg="#000000")
    BC3.config(fg="#ffffff", bg="#000000")
    BC4.config(fg="#ffffff", bg="#000000")


def knoeppe_aendern0():
    B44.config(text="Kreiszahl PI", command=pi_suche, bg='#5555ff', cursor='question_arrow', font=schrift)
    B45.config(text="Eulersche Zahl", command=euler_suche, bg='#5555ff', cursor='question_arrow', font=schrift)
    B46.config(text="phi (goldener Schnitt)", command=goldener_schnitt_suche, bg='#5555ff', cursor='question_arrow',
               font=schrift)
    B47.config(text="! Brainfuck-Interpreter", command=brainfuck_interpreter, bg='#FFA94F', cursor='question_arrow',
               font=schrift)
    B48.config(text="! Ook/ShortOok-Interp.", command=ook_interpreter, bg='#FFA94F', cursor='question_arrow',
               font=schrift)
    B49.config(text="Text->Tomtom", command=abctotomtom, bg='#FFA98F', cursor='question_arrow', font=schrift)
    B50.config(text="Tomtom->Text", command=tomtomtoabc, bg='#FFA98F', cursor='question_arrow', font=schrift)
    B51.config(text="Text->Slash and Pipe", command=texttoslashpipe, bg='#FFA98F', cursor='question_arrow',
               font=schrift)
    B52.config(text="Slash and Pipe->Text", command=slashpipetotext, bg='#FFA98F', cursor='question_arrow',
               font=schrift)
    B53.config(text="Mono.-Substitution", command=monoalphasubstitution, bg='#8888ff', cursor='question_arrow',
               font=schrift)
    B54.config(text="Woseley-Chiffre", command=wolseley, bg='#8888ff', cursor='question_arrow', font=schrift)
    B55.config(text="Atbash-Chiffre", command=atbash, bg='#8888ff', cursor='question_arrow', font=schrift)
    B56.config(text="Autokey-Chiffre", command=autokey, bg='#8888ff', cursor='question_arrow', font=schrift)
    B57.config(text="Vigenere-Chiffre", command=vigenere, bg='#8888ff', cursor='question_arrow', font=schrift)
    B58.config(text="Polybios kodieren", command=polybios_encode, bg='#8888ff', cursor='question_arrow', font=schrift)
    B59.config(text="Polybios dekodieren", command=polybios_decode, bg='#8888ff', cursor='question_arrow', font=schrift)
    B60.config(text="Klopfcode kodieren", command=klopfcode_encode, bg='#8888ff', cursor='question_arrow', font=schrift)
    B61.config(text="Klopfcode dekodieren", command=klopfcode_decode, bg='#8888ff', cursor='question_arrow',
               font=schrift)
    B62.config(text="ADFGX kodieren", command=adfgvx_kodieren, bg='#8888ff', cursor='question_arrow', font=schrift)
    B63.config(text="ADFGX dekodieren", command=adfgx_dekodieren, bg='#8888ff', cursor='question_arrow', font=schrift)
    B64.config(text="ADFGVX kodieren", command=adfgvx_kodieren, bg='#8888ff', cursor='question_arrow', font=schrift)
    B65.config(text="ADFGVX dekodieren", command=adfgvx_dekodieren, bg='#8888ff', cursor='question_arrow', font=schrift)

    BC0.config(fg="#000000", bg="#ffffff")
    BC1.config(fg="#ffffff", bg="#000000")
    BC2.config(fg="#ffffff", bg="#000000")
    BC3.config(fg="#ffffff", bg="#000000")
    BC4.config(fg="#ffffff", bg="#000000")


# -----------------------------------------------------------------------------------------------------------
def infofenster():
    ifenster = Tk()
    ifenster.title("Info")
    itext = """INFO!
Viel Spaß beim Benutzen des Programms!
Ich hoffe dem ein oder anderen hilft es ein wenig.
Happy hunting! tebarius
"""
    info_text = Label(ifenster, text=itext, font=schrift)
    website_link = Label(ifenster, text="Homepage", fg="blue", cursor="hand2", font=schrift)
    website_link.bind("<Button-1>", lambda event: webbrowser.open_new(website))
    gc_link = Label(ifenster, text="meine geocaching.com-Profilseite", fg="blue", cursor="hand2", font=schrift)
    gc_link.bind("<Button-1>", lambda event: webbrowser.open_new("https://www.geocaching.com/p/?u=tebarius"))
    info_exit = Button(ifenster, text="Danke!", command=ifenster.destroy, bg='#FF4444', cursor='target', font=schrift)

    info_text.grid(row=0, column=0, pady=5)
    website_link.grid(row=1, column=0, pady=5)
    gc_link.grid(row=2, column=0, pady=5)
    info_exit.grid(row=3, column=0, pady=5)


# --Konfig-----------------------------------------------------------------------------------------------------

def configfenster():
    def standard_font():
        font_family.set("Times New Roman")
        font_size.set(10)
        font_style.set("normal")
        selected_font = font_family.get()
        selected_size = font_size.get()
        selected_style = font_style.get()
        config_text_label.config(font=(selected_font, selected_size, selected_style))
        config_text_label.config(text=f"Vorschau: {selected_font}, {selected_size}, {selected_style}")

    def preview_font():
        selected_font = font_family.get()
        selected_size = font_size.get()
        selected_style = font_style.get()
        config_text_label.config(font=(selected_font, selected_size, selected_style))
        config_text_label.config(text=f"Vorschau: {selected_font}, {selected_size}, {selected_style}")

    def save_font():
        selected_font = font_family.get()
        selected_size = font_size.get()
        selected_style = font_style.get()
        config_text_label.config(font=(selected_font, selected_size, selected_style))
        try:
            config_file = open("./data/config.txt", "w", encoding="utf-8")
            config_file.write(f"font = {selected_font}\n")
            config_file.write(f"size = {selected_size}\n")
            config_file.write(f"style = {selected_style}\n")
            config_text_label.config(text="Gespeichert! Bitte Programm neu starten!")
        except FileNotFoundError:
            config_text_label.config(text="Speichern fehlgeschlagen!")

    # Erstelle das Konfigfenster
    config_fenster = Tk()
    config_fenster.title("Font Configuration")

    # Schriftarten auswählen
    font_families = font.families()

    # Schriftartauswahl
    font_family_label = Label(config_fenster, text="Font Family:")
    font_family_label.grid(row=0, column=0, sticky="w")
    font_family = StringVar(config_fenster)
    font_family.set(font_families[0])  # Standard-Schriftart
    font_family_menu = ttk.Combobox(config_fenster, textvariable=font_family, values=font_families, state="readonly")
    font_family_menu.grid(row=0, column=1, columnspan=2, padx=10, pady=5)

    font_sizes = [5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]
    # Schriftartauswahl
    font_size_label = Label(config_fenster, text="Font Size:")
    font_size_label.grid(row=1, column=0, sticky="w")
    font_size = IntVar(config_fenster)
    font_size.set(font_sizes[5])  # Standard-groesse 10
    font_size_menu = ttk.Combobox(config_fenster, textvariable=font_size, values=font_sizes, state="readonly")
    font_size_menu.grid(row=1, column=1, columnspan=2, padx=10, pady=5)

    # Schriftart-Stilauswahl
    font_style_label = Label(config_fenster, text="Font Style:")
    font_style_label.grid(row=2, column=0, sticky="w")
    font_styles = ["normal", "bold", "italic", "underline"]
    font_style = StringVar(config_fenster)
    font_style.set(font_styles[0])  # Standard-Schriftart-Stil
    font_style_menu = ttk.Combobox(config_fenster, textvariable=font_style, values=font_styles, state="readonly")
    font_style_menu.grid(row=2, column=1, columnspan=2, padx=10, pady=5)

    # Schriftart anwenden Button
    defaultfont_button = Button(config_fenster, text="Standard", command=standard_font)
    defaultfont_button.grid(row=3, column=0, padx=10, pady=5)
    preview_button = Button(config_fenster, text="Vorschau", command=preview_font)
    preview_button.grid(row=3, column=1, padx=10, pady=5)
    save_button = Button(config_fenster, text="Speichern", command=save_font)
    save_button.grid(row=3, column=2, padx=10, pady=5)

    # Textlabel für Vorschau
    config_text_label = Label(config_fenster, text="Vorschau: Beispieltext", font=(font_families[0], 10))
    config_text_label.grid(row=4, column=0, columnspan=3, padx=10, pady=5)

    # Exit-Button
    save_button = Button(config_fenster, text="Schließen", command=config_fenster.destroy, bg='#FF4444',
                         cursor='target')
    save_button.grid(row=5, column=1, padx=10, pady=5)
    config_fenster.mainloop()


# -Hauptfenster-------------------------------------------------------------------------------------------------------
fenster = Tk()
fenster.title("tebarius kleiner Mysteryhelfer " + versionsnummer)
# fenster.resizable(False, False) # Auschalten der Möglichkeit das Hauptfenster größer/kleiner zu machen
bgcolor_default = fenster.cget("bg")
# LOGO
logodata = PhotoImage(data=LOGOIMG)
Logo = Button(image=logodata, command=infofenster, cursor="trek")

# Konfig
Konfig = Button(fenster, text="\u2699 Konfig", command=configfenster, bg='#83a88e', cursor='trek',
                font=("Times New Roman", 10))

# Updatecheck
updatecheck_button = Button(fenster, text="Update-Check", command=check_update, bg='#83a88e', cursor='trek',
                            font=("Times New Roman", 10))

# Anweisungs-Label
Aufforderung = Label(fenster,
                     text="Hier zu untersuchende Zeichenkette eingeben (Hilfetexte erscheinen bei leerem Eingabefeld)",
                     font=schrift)

# Hier kann der Benutzer eine Eingabe machen
eingabe_scrollbar = Scrollbar(fenster)
Eingabe = Text(fenster, bd=2, width=80, height=10, relief=RAISED, cursor='xterm', font=schrift,
               yscrollcommand=eingabe_scrollbar.set)
eingabe_scrollbar.config(command=Eingabe.yview)

# Schlüsseleingabefeld
PW_Label = Label(fenster, text="Schlüssel:", font=schrift)
PW_Eingabe = Entry(fenster, bd=2, width=25, relief=RAISED, cursor='xterm', font=schrift)

# In diesem Label erfolgt die Ausgabe der Funde
ausgabe_scrollbar = Scrollbar(fenster)
Ausgabe = Text(fenster, bd=2, width=80, height=28, relief=RAISED, cursor='xterm', font=schrift,
               yscrollcommand=ausgabe_scrollbar.set)
ausgabe_scrollbar.config(command=Ausgabe.yview)
Ausgabe.insert(1.0, """
Ausgabefeld:

In diesem Feld erfolgt die Ausgabe der Funktionen.
Neueste Ergebnisse erscheinen immer zuoberst!!!!!

!!!!!ACHTUNG!!!!!
Mit ! gekennzeichnete Funktionen können unter ungünstigen
Umständen das Programm zum Absturz oder Einfrieren bringen!

Um den HILFE-Text zu einzelnen Funktionen
aufzurufen bitte mit leerem Eingabefeld den
jeweiligen Funktionsknopf betätigen.""")
Ausgabe.tag_config("bu", foreground="blue", underline=True)
Ausgabe.tag_config("re", foreground="red")
Ausgabe.tag_config("gr", foreground="green")

# Actionknöppe
B1 = Button(fenster, text="Ausgabefeld leeren!!!", command=ausgabe_leeren, bg='#FFFFFF', cursor='hand2', font=schrift)
B1a = Button(fenster, text="EINFÜGEN (Ersetzen)", command=eingabe_einfuegen, bg='#FFFFFF', cursor='hand2', font=schrift)
B1b = Button(fenster, text="Eingabe leeren!!!", command=eingabe_leeren, bg='#FFFFFF', cursor='hand2', font=schrift)
B1c = Button(fenster, text="Auswahl von Ausgabe in Zwischenablage", command=auswahl_kopieren, bg='#FFFFE0',
             cursor='hand2', font=schrift)

B2 = Button(fenster, text="Cesarchiffre_all", command=cesar_all, bg='#FFE97F', cursor='question_arrow', font=schrift)
B3 = Button(fenster, text="BW,BWW,... ermitteln", command=buchstabenwortwert, bg='#FFE97F', cursor='question_arrow',
            font=schrift)
B4 = Button(fenster, text="Buchstabenwert->Text", command=buchstabenwertzutext, bg='#FFE97F', cursor='question_arrow',
            font=schrift)
B5 = Button(fenster, text="Zeichenzählen", command=zeichenzaehlen, bg='#FFE97F', cursor='question_arrow', font=schrift)
B6 = Button(fenster, text="Quersumme(n)", command=quersummen, bg='#FFE97F', cursor='question_arrow', font=schrift)
B7 = Button(fenster, text="Text rückwärts", command=zeichenkette_rueckwaerts, bg='#FFE97F', cursor='question_arrow',
            font=schrift)
B8 = Button(fenster, text="ABC -> Morse", command=abctomorse, bg='#FFA98F', cursor='question_arrow', font=schrift)
B9 = Button(fenster, text="Morse -> ABC", command=morsetoabc, bg='#FFA98F', cursor='question_arrow', font=schrift)
B10 = Button(fenster, text="ROT5", command=rot5, bg='#FFE97F', cursor='question_arrow', font=schrift)
B11 = Button(fenster, text="ROT13", command=rot13, bg='#FFE97F', cursor='question_arrow', font=schrift)
B12 = Button(fenster, text="ROT18", command=rot18, bg='#FFE97F', cursor='question_arrow', font=schrift)
B13 = Button(fenster, text="ROT47", command=rot47, bg='#FFE97F', cursor='question_arrow', font=schrift)
B14 = Button(fenster, text="Zahlwortsuche-DE (0-12)", command=zahlwortsuche_de, bg='#4FE97F', cursor='question_arrow',
             font=schrift)
B15 = Button(fenster, text="Zahlwortsuche-EN (0-15)", command=zahlwortsuche_en, bg='#4FE97F', cursor='question_arrow',
             font=schrift)
B16 = Button(fenster, text="Einschlüsse(mit 4)", command=einschluessemit4, bg='#FFA94F', cursor='question_arrow',
             font=schrift)
B17 = Button(fenster, text="Einschlüsse(ohne 4)", command=einschluesseohne4, bg='#FFA94F', cursor='question_arrow',
             font=schrift)
B18 = Button(fenster, text="Primz.Alpha dekodieren", command=primzahlalphabet_dekodieren, bg='#00A4AA',
             cursor='question_arrow', font=schrift)
B19 = Button(fenster, text="ist (n.te) Primzahl?", command=primzahlpruefen, bg='#00A4AA', cursor='question_arrow',
             font=schrift)
B20 = Button(fenster, text="zeige n.te Primzahl", command=nte_primzahl, bg='#00A4AA', cursor='question_arrow',
             font=schrift)
B21 = Button(fenster, text="Primfaktorenzerlegung", command=primfaktoren, bg='#00a4aa', cursor='question_arrow',
             font=schrift)
B22 = Button(fenster, text="PSE: O.zahl<->Symbol", command=periodensystem, bg='#2FE94F', cursor='question_arrow',
             font=schrift)
B23 = Button(fenster, text="Anagrammsuche-DE", command=anagramm_suche_de, bg='#ff55ff', cursor='question_arrow',
             font=schrift)
B24 = Button(fenster, text="Anagrammsuche-EN", command=anagramm_suche_en, bg='#ff55ff', cursor='question_arrow',
             font=schrift)
B25 = Button(fenster, text="ASCII-Text->HEX", command=asciitohex, bg='#EFE97F', cursor='question_arrow', font=schrift)
B26 = Button(fenster, text="ASCII-Text->DEZ", command=asciitodez, bg='#EFE97F', cursor='question_arrow', font=schrift)
B27 = Button(fenster, text="ASCII-Text->Octal", command=asciitooctal, bg='#EFE97F', cursor='question_arrow',
             font=schrift)
B28 = Button(fenster, text="ASCII-Text->BIN (16bit)", command=asciitobin16, bg='#EFE97F', cursor='question_arrow',
             font=schrift)
B29 = Button(fenster, text="ASCII-Text->BIN (8bit)", command=asciitobin8, bg='#EFE97F', cursor='question_arrow',
             font=schrift)
B30 = Button(fenster, text="HEX->ASCII-Text", command=hextoascii, bg='#DFA97F', cursor='question_arrow', font=schrift)
B31 = Button(fenster, text="DEZ->ASCII-Text", command=deztoascii, bg='#DFA97F', cursor='question_arrow', font=schrift)
B32 = Button(fenster, text="Octal->ASCII-Text", command=octaltoascii, bg='#DFA97F', cursor='question_arrow',
             font=schrift)
B33 = Button(fenster, text="BIN->ASCII-Text", command=bintoascii, bg='#DFA97F', cursor='question_arrow', font=schrift)
B34 = Button(fenster, text="HEX -> DEZ,OCT,BIN", command=hextodezoctbin, bg='#2FE94F', cursor='question_arrow',
             font=schrift)
B35 = Button(fenster, text="DEZ -> HEX,OCT,BIN", command=deztohexoctbin, bg='#2FE94F', cursor='question_arrow',
             font=schrift)
B36 = Button(fenster, text="OCT -> HEX,DEZ,BIN", command=octtohexdezbin, bg='#2FE94F', cursor='question_arrow',
             font=schrift)
B37 = Button(fenster, text="BIN -> HEX,DEZ,OCT", command=bintohexdezoct, bg='#2FE94F', cursor='question_arrow',
             font=schrift)
B38 = Button(fenster, text="Nak-Nak -> Text", command=naknaktotext, bg='#FFFF00', cursor='question_arrow', font=schrift)
B39 = Button(fenster, text="Navajo -> Text", command=navajototext, bg='#009900', cursor='question_arrow', font=schrift)
B40 = Button(fenster, text="Re-Morse-DE", command=remorse_de, bg='#55ff55', cursor='question_arrow', font=schrift)
B41 = Button(fenster, text="Re-Morse-EN", command=remorse_en, bg='#55ff55', cursor='question_arrow', font=schrift)
B42 = Button(fenster, text="Chronogramm", command=chronogramm, bg='#FFA98F', cursor='question_arrow', font=schrift)
B43 = Button(fenster, text="Zahl röm.<->arabisch", command=zahlen_roemisch_arabisch_umwandeln, bg='#FF897F',
             cursor='question_arrow', font=schrift)
B44 = Button(fenster, text="Kreiszahl PI", command=pi_suche, bg='#5555ff', cursor='question_arrow', font=schrift)
B45 = Button(fenster, text="Eulersche Zahl", command=euler_suche, bg='#5555ff', cursor='question_arrow', font=schrift)
B46 = Button(fenster, text="phi (goldener Schnitt)", command=goldener_schnitt_suche, bg='#5555ff',
             cursor='question_arrow', font=schrift)
B47 = Button(fenster, text="! Brainfuck-Interpreter", command=brainfuck_interpreter, bg='#FFA94F',
             cursor='question_arrow', font=schrift)
B48 = Button(fenster, text="! Ook/ShortOok-Interp.", command=ook_interpreter, bg='#FFA94F', cursor='question_arrow',
             font=schrift)
B49 = Button(fenster, text="Text->Tomtom", command=abctotomtom, bg='#FFA98F', cursor='question_arrow', font=schrift)
B50 = Button(fenster, text="Tomtom->Text", command=tomtomtoabc, bg='#FFA98F', cursor='question_arrow', font=schrift)
B51 = Button(fenster, text="Text->Slash and Pipe", command=texttoslashpipe, bg='#FFA98F', cursor='question_arrow',
             font=schrift)
B52 = Button(fenster, text="Slash and Pipe->Text", command=slashpipetotext, bg='#FFA98F', cursor='question_arrow',
             font=schrift)
B53 = Button(fenster, text="Mono.-Substitution", command=monoalphasubstitution, bg='#8888ff', cursor='question_arrow',
             font=schrift)
B54 = Button(fenster, text="Woseley-Chiffre", command=wolseley, bg='#8888ff', cursor='question_arrow', font=schrift)
B55 = Button(fenster, text="Atbash-Chiffre", command=atbash, bg='#8888ff', cursor='question_arrow', font=schrift)
B56 = Button(fenster, text="Autokey-Chiffre", command=autokey, bg='#8888ff', cursor='question_arrow', font=schrift)
B57 = Button(fenster, text="Vigenere-Chiffre", command=vigenere, bg='#8888ff', cursor='question_arrow', font=schrift)
B58 = Button(fenster, text="Polybios kodieren", command=polybios_encode, bg='#8888ff', cursor='question_arrow',
             font=schrift)
B59 = Button(fenster, text="Polybios dekodieren", command=polybios_decode, bg='#8888ff', cursor='question_arrow',
             font=schrift)
B60 = Button(fenster, text="Klopfcode kodieren", command=klopfcode_encode, bg='#8888ff', cursor='question_arrow',
             font=schrift)
B61 = Button(fenster, text="Klopfcode dekodieren", command=klopfcode_decode, bg='#8888ff', cursor='question_arrow',
             font=schrift)
B62 = Button(fenster, text="ADFGX kodieren", command=adfgx_kodieren, bg='#8888ff', cursor='question_arrow',
             font=schrift)
B63 = Button(fenster, text="ADFGX dekodieren", command=adfgx_dekodieren, bg='#8888ff', cursor='question_arrow',
             font=schrift)
B64 = Button(fenster, text="ADFGVX kodieren", command=adfgvx_kodieren, bg='#8888ff', cursor='question_arrow',
             font=schrift)
B65 = Button(fenster, text="ADFGVX dekodieren", command=adfgvx_dekodieren, bg='#8888ff', cursor='question_arrow',
             font=schrift)

BC0 = Button(fenster, text="0", command=knoeppe_aendern0, fg="#000000", bg="#ffffff", font=schrift)
BC1 = Button(fenster, text="1", command=knoeppe_aendern1, fg="#ffffff", bg="#000000", font=schrift)
BC2 = Button(fenster, text="2", command=knoeppe_aendern2, fg="#ffffff", bg="#000000", font=schrift)
BC3 = Button(fenster, text="3", command="", fg="#ffffff", bg="#000000", font=schrift)
BC4 = Button(fenster, text="4", command="", fg="#ffffff", bg="#000000", font=schrift)

Bexit = Button(fenster, text="Beenden", command=fenster.quit, bg='#FF4444', cursor='target', font=schrift)

# Nun fügen wir die Komponenten unserem Fenster hinzu
Logo.grid(row=0, column=5, rowspan=3)
Konfig.grid(row=0, column=0, pady=1, padx=10, sticky=W)
updatecheck_button.grid(row=0, column=2, pady=1, padx=10, sticky=E)
Aufforderung.grid(row=1, column=0, columnspan=3)
Eingabe.grid(row=2, column=0, rowspan=6, columnspan=3, pady=1, padx=(10, 0), sticky=N + S + E + W)
eingabe_scrollbar.grid(row=2, rowspan=6, column=3, padx=(0, 5), sticky=N + S)
Ausgabe.grid(row=9, column=0, rowspan=15, columnspan=3, pady=5, padx=(10, 0), sticky=N + S + E + W)
ausgabe_scrollbar.grid(row=9, rowspan=15, column=3, padx=(0, 5), sticky=N + S)
PW_Label.grid(row=8, column=0, pady=1, padx=(10, 0), sticky=E)
PW_Eingabe.grid(row=8, column=1, pady=1, padx=(0, 10), sticky=W)
B1c.grid(row=8, column=2, pady=1, sticky=E)
B1.grid(row=0, column=4, padx=5, sticky=W + E)
B1a.grid(row=2, column=4, padx=5, sticky=W + E)
B1b.grid(row=1, column=4, padx=5, sticky=W + E)
B2.grid(row=3, column=4, padx=5, pady=1, sticky=W + E)
B3.grid(row=4, column=4, padx=5, pady=1, sticky=W + E)
B4.grid(row=5, column=4, padx=5, pady=1, sticky=W + E)
B5.grid(row=6, column=4, padx=5, pady=1, sticky=W + E)
B6.grid(row=7, column=4, padx=5, pady=1, sticky=W + E)
B7.grid(row=8, column=4, padx=5, pady=1, sticky=W + E)
B8.grid(row=9, column=4, padx=5, pady=1, sticky=W + E)
B9.grid(row=10, column=4, padx=5, pady=1, sticky=W + E)
B10.grid(row=11, column=4, padx=5, pady=1, sticky=W + E)
B11.grid(row=12, column=4, padx=5, pady=1, sticky=W + E)
B12.grid(row=13, column=4, padx=5, pady=1, sticky=W + E)
B13.grid(row=14, column=4, padx=5, pady=1, sticky=W + E)
B14.grid(row=15, column=4, padx=5, pady=1, sticky=W + E)
B15.grid(row=16, column=4, padx=5, pady=1, sticky=W + E)
B16.grid(row=17, column=4, padx=5, pady=1, sticky=W + E)
B17.grid(row=18, column=4, padx=5, pady=1, sticky=W + E)
B18.grid(row=19, column=4, padx=5, pady=1, sticky=W + E)
B19.grid(row=20, column=4, padx=5, pady=1, sticky=W + E)
B20.grid(row=21, column=4, padx=5, pady=1, sticky=W + E)
B21.grid(row=22, column=4, padx=5, pady=1, sticky=W + E)
B22.grid(row=23, column=4, padx=5, pady=1, sticky=W + E)
B23.grid(row=3, column=5, padx=5, pady=1, sticky=W + E)
B24.grid(row=4, column=5, padx=5, pady=1, sticky=W + E)
B25.grid(row=5, column=5, padx=5, pady=1, sticky=W + E)
B26.grid(row=6, column=5, padx=5, pady=1, sticky=W + E)
B27.grid(row=7, column=5, padx=5, pady=1, sticky=W + E)
B28.grid(row=8, column=5, padx=5, pady=1, sticky=W + E)
B29.grid(row=9, column=5, padx=5, pady=1, sticky=W + E)
B30.grid(row=10, column=5, padx=5, pady=1, sticky=W + E)
B31.grid(row=11, column=5, padx=5, pady=1, sticky=W + E)
B32.grid(row=12, column=5, padx=5, pady=1, sticky=W + E)
B33.grid(row=13, column=5, padx=5, pady=1, sticky=W + E)
B34.grid(row=14, column=5, padx=5, pady=1, sticky=W + E)
B35.grid(row=15, column=5, padx=5, pady=1, sticky=W + E)
B36.grid(row=16, column=5, padx=5, pady=1, sticky=W + E)
B37.grid(row=17, column=5, padx=5, pady=1, sticky=W + E)
B38.grid(row=18, column=5, padx=5, pady=1, sticky=W + E)
B39.grid(row=19, column=5, padx=5, pady=1, sticky=W + E)
B40.grid(row=20, column=5, padx=5, pady=1, sticky=W + E)
B41.grid(row=21, column=5, padx=5, pady=1, sticky=W + E)
B42.grid(row=22, column=5, padx=5, pady=1, sticky=W + E)
B43.grid(row=23, column=5, padx=5, pady=1, sticky=W + E)

BC0.grid(row=0, column=6, pady=1)
BC1.grid(row=0, column=7, pady=1)
BC2.grid(row=0, column=8, pady=1)
BC3.grid(row=0, column=9, pady=1)
BC4.grid(row=0, column=10, pady=1)

B44.grid(row=1, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B45.grid(row=2, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B46.grid(row=3, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B47.grid(row=4, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B48.grid(row=5, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B49.grid(row=6, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B50.grid(row=7, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B51.grid(row=8, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B52.grid(row=9, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B53.grid(row=10, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B54.grid(row=11, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B55.grid(row=12, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B56.grid(row=13, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B57.grid(row=14, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B58.grid(row=15, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B59.grid(row=16, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B60.grid(row=17, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B61.grid(row=18, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B62.grid(row=19, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B63.grid(row=20, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B64.grid(row=21, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
B65.grid(row=22, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)
Bexit.grid(row=23, column=6, padx=5, pady=1, sticky=W + E, columnspan=5)

mainloop()
